/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.meta.data;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openspaces.persistency.cassandra.meta.ColumnFamilyMetadata;
import org.openspaces.persistency.cassandra.meta.data.ColumnData;

public class ColumnFamilyRow {
    private final Map<String, ColumnData> columns = new HashMap<String, ColumnData>();
    private final List<ColumnData> dynamicColumns = new LinkedList<ColumnData>();
    private final ColumnFamilyMetadata columnFamilyMetadata;
    private final Object keyValue;
    private final ColumnFamilyRowType rowType;

    public ColumnFamilyRow(ColumnFamilyMetadata columnFamilyMetadata, Object keyValue, ColumnFamilyRowType rowType) {
        this.columnFamilyMetadata = columnFamilyMetadata;
        this.keyValue = keyValue;
        this.rowType = rowType;
    }

    public void addColumnData(ColumnData columnData) {
        this.columns.put(columnData.getColumnMetadata().getFullName(), columnData);
        if (columnData.isDynamicColumn()) {
            this.dynamicColumns.add(columnData);
        }
    }

    public ColumnData getColumn(String name) {
        return this.columns.get(name);
    }

    public List<ColumnData> getDynamicColumns() {
        return this.dynamicColumns;
    }

    public Map<String, ColumnData> getColumns() {
        return this.columns;
    }

    public ColumnFamilyMetadata getColumnFamilyMetadata() {
        return this.columnFamilyMetadata;
    }

    public Object getKeyValue() {
        return this.keyValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ColumnFamilyRow[ ");
        sb.append((Object)this.rowType).append(" ");
        sb.append("typeName: ").append(this.columnFamilyMetadata.getTypeName()).append(", ");
        sb.append("key: ").append(this.keyValue).append(", ");
        sb.append("column names: ").append(this.columns.keySet());
        sb.append(" ]");
        return sb.toString();
    }

    public ColumnFamilyRowType getRowType() {
        return this.rowType;
    }

    public static enum ColumnFamilyRowType {
        Read,
        Remove,
        Write,
        Update,
        PartialUpdate;

    }
}

