/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.meta.mapping;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexType;
import java.util.HashSet;
import java.util.Map;
import org.openspaces.persistency.cassandra.meta.ColumnFamilyMetadata;
import org.openspaces.persistency.cassandra.meta.conversion.ColumnFamilyNameConverter;
import org.openspaces.persistency.cassandra.meta.conversion.DefaultColumnFamilyNameConverter;
import org.openspaces.persistency.cassandra.meta.data.ColumnFamilyRow;
import org.openspaces.persistency.cassandra.meta.mapping.SpaceDocumentColumnFamilyMapper;
import org.openspaces.persistency.cassandra.meta.mapping.SpaceTypeDescriptorHolder;
import org.openspaces.persistency.cassandra.meta.mapping.filter.FlattenedPropertiesFilter;
import org.openspaces.persistency.cassandra.meta.mapping.node.SpaceDocumentTopLevelTypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.TopLevelTypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.TypeNodeContext;
import org.openspaces.persistency.cassandra.meta.mapping.node.TypeNodeIntrospector;
import org.openspaces.persistency.cassandra.meta.types.dynamic.PropertyValueSerializer;

public class DefaultSpaceDocumentColumnFamilyMapper
implements SpaceDocumentColumnFamilyMapper {
    private final TypeNodeIntrospector typeNodeIntrospector;
    private final ColumnFamilyNameConverter columnFamilyNameConverter;

    public DefaultSpaceDocumentColumnFamilyMapper(PropertyValueSerializer fixedPropertyValueSerializer, PropertyValueSerializer dynamicPropertyValueSerializer, FlattenedPropertiesFilter flattenePropertiesFilter, ColumnFamilyNameConverter columnFamilyNameConverter) {
        this.typeNodeIntrospector = new TypeNodeIntrospector(fixedPropertyValueSerializer, dynamicPropertyValueSerializer, flattenePropertiesFilter);
        this.columnFamilyNameConverter = columnFamilyNameConverter == null ? new DefaultColumnFamilyNameConverter() : columnFamilyNameConverter;
    }

    public DefaultSpaceDocumentColumnFamilyMapper(PropertyValueSerializer fixedPropertyValueSerializer, PropertyValueSerializer dynamicPropertyValueSerializer) {
        this(fixedPropertyValueSerializer, dynamicPropertyValueSerializer, null, null);
    }

    @Override
    public ColumnFamilyMetadata toColumnFamilyMetadata(SpaceTypeDescriptor typeDescriptor) {
        SpaceTypeDescriptorHolder typeDescriptorData = new SpaceTypeDescriptorHolder(typeDescriptor);
        Map indexes = typeDescriptor.getIndexes();
        HashSet<String> initialIndexes = new HashSet<String>();
        if (indexes != null) {
            for (SpaceIndex index : indexes.values()) {
                if (index.getIndexType() == SpaceIndexType.NONE || index.getName().equals(typeDescriptor.getIdPropertyName())) continue;
                initialIndexes.add(index.getName());
            }
        }
        TopLevelTypeNode topLevelTypeNode = this.typeNodeIntrospector.introspectTypeDescriptor(typeDescriptor);
        return new ColumnFamilyMetadata(topLevelTypeNode, initialIndexes, this.columnFamilyNameConverter, typeDescriptorData);
    }

    @Override
    public SpaceDocument toDocument(ColumnFamilyRow columnFamilyRow) {
        SpaceDocumentTopLevelTypeNode topLevelTypeNode = (SpaceDocumentTopLevelTypeNode)columnFamilyRow.getColumnFamilyMetadata().getTopLevelTypeNode();
        return topLevelTypeNode.readFromColumnFamilyRow(columnFamilyRow, new TypeNodeContext(this.typeNodeIntrospector, true));
    }

    @Override
    public ColumnFamilyRow toColumnFamilyRow(ColumnFamilyMetadata metadata, SpaceDocument document, ColumnFamilyRow.ColumnFamilyRowType type, boolean useDynamicPropertySerializerForDynamicColumns) {
        String keyName = metadata.getKeyName();
        Object keyValue = document.getProperty(keyName);
        ColumnFamilyRow row = new ColumnFamilyRow(metadata, keyValue, type);
        metadata.getTopLevelTypeNode().writeToColumnFamilyRow(document, row, new TypeNodeContext(this.typeNodeIntrospector, useDynamicPropertySerializerForDynamicColumns));
        return row;
    }

    @Override
    public TypeNodeIntrospector getTypeNodeIntrospector() {
        return this.typeNodeIntrospector;
    }
}

