/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.meta.mapping.node;

import java.util.HashMap;
import java.util.Map;
import org.openspaces.persistency.cassandra.meta.DynamicColumnMetadata;
import org.openspaces.persistency.cassandra.meta.TypedColumnMetadata;
import org.openspaces.persistency.cassandra.meta.data.ColumnData;
import org.openspaces.persistency.cassandra.meta.data.ColumnFamilyRow;
import org.openspaces.persistency.cassandra.meta.mapping.node.CompoundTypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.TypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.TypeNodeContext;

public abstract class AbstractCompoundTypeNode
implements CompoundTypeNode {
    private final Map<String, TypeNode> children = new HashMap<String, TypeNode>();

    @Override
    public Map<String, TypedColumnMetadata> getAllTypedColumnMetadataChildren() {
        HashMap<String, TypedColumnMetadata> result = new HashMap<String, TypedColumnMetadata>();
        for (TypeNode child : this.children.values()) {
            if (child instanceof TypedColumnMetadata) {
                TypedColumnMetadata columnMetadata = (TypedColumnMetadata)child;
                result.put(child.getFullName(), columnMetadata);
                continue;
            }
            if (child instanceof DynamicColumnMetadata) {
                throw new IllegalStateException("Dynamic columns should not be part of the column family metadata static columns");
            }
            result.putAll(((CompoundTypeNode)child).getAllTypedColumnMetadataChildren());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToColumnFamilyRow(Object value, ColumnFamilyRow row, TypeNodeContext context) {
        context.increaseNestingLevel();
        try {
            String dynamicHeaderColumnName;
            if (context.isDynamic() && (dynamicHeaderColumnName = this.getDynamicHeaderColumnName()) != null) {
                row.addColumnData(new ColumnData(dynamicHeaderColumnName, new DynamicColumnMetadata(this.getFullName(), context.getTypeNodeIntrospector().getDynamicPropertyValueSerializer())));
            }
            this.writeToColumnFamilyRowImpl(value, row, context);
        }
        finally {
            context.descreaseNestingLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePropertyToColumnFamilyRow(ColumnFamilyRow row, String propertyName, Object propertyValue, TypeNodeContext context) {
        boolean parentIsDynamicContext;
        boolean currentIsDynamicContext = parentIsDynamicContext = context.isDynamic();
        TypeNode typeNode = this.getChildren().get(propertyName);
        if (typeNode == null) {
            currentIsDynamicContext = true;
            context.setDynamic(currentIsDynamicContext);
            try {
                typeNode = context.getTypeNodeIntrospector().introspect(this.getFullName(), propertyName, propertyValue, context);
            }
            finally {
                context.setDynamic(parentIsDynamicContext);
            }
        }
        context.setDynamic(currentIsDynamicContext);
        try {
            typeNode.writeToColumnFamilyRow(propertyValue, row, context);
        }
        finally {
            context.setDynamic(parentIsDynamicContext);
        }
    }

    protected abstract void writeToColumnFamilyRowImpl(Object var1, ColumnFamilyRow var2, TypeNodeContext var3);

    protected abstract String getDynamicHeaderColumnName();

    protected Map<String, TypeNode> getChildren() {
        return this.children;
    }
}

