/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.meta.mapping.node;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.pojo.PojoPropertyInfo;
import com.gigaspaces.internal.metadata.pojo.PojoTypeInfo;
import com.gigaspaces.internal.metadata.pojo.PojoTypeInfoRepository;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.openspaces.persistency.cassandra.error.SpaceCassandraTypeIntrospectionException;
import org.openspaces.persistency.cassandra.meta.DynamicColumnMetadata;
import org.openspaces.persistency.cassandra.meta.data.ColumnData;
import org.openspaces.persistency.cassandra.meta.data.ColumnFamilyRow;
import org.openspaces.persistency.cassandra.meta.mapping.node.AbstractCompoundTypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.ExternalizableTypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.TypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.TypeNodeContext;

public class PojoTypeNode
extends AbstractCompoundTypeNode
implements ExternalizableTypeNode {
    private static final long serialVersionUID = 1L;
    public static final byte SERIAL_VER = -128;
    private String fullName;
    private String name;
    private Class<?> type;
    private Constructor<Object> constructor;
    private final Map<String, Method> getters = new HashMap<String, Method>();
    private final Map<String, Method> setters = new HashMap<String, Method>();

    public PojoTypeNode() {
    }

    public PojoTypeNode(String parentFullName, String name, Class<?> type, TypeNodeContext context) {
        this.fullName = (parentFullName != null ? parentFullName + "." : "") + name;
        this.name = name;
        this.type = type;
        this.initFields(context);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    private void initFields(TypeNodeContext context) {
        PojoTypeInfo typeInfo = PojoTypeInfoRepository.getPojoTypeInfo(this.type);
        try {
            this.constructor = this.type.getConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            throw new SpaceCassandraTypeIntrospectionException("Could not find default constructor for type: " + this.type.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new SpaceCassandraTypeIntrospectionException("Could not find default constructor for type: " + this.type.getName(), e);
        }
        for (PojoPropertyInfo property : typeInfo.getProperties().values()) {
            if ("class".equals(property.getName()) || property.getGetterMethod() == null || property.getSetterMethod() == null) continue;
            this.getters.put(property.getName(), property.getGetterMethod());
            this.setters.put(property.getName(), property.getSetterMethod());
        }
        if (context == null) {
            return;
        }
        this.introspectFixedProperties(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspectFixedProperties(TypeNodeContext context) {
        context.increaseNestingLevel();
        try {
            for (Map.Entry<String, Method> entry : this.getters.entrySet()) {
                String name = entry.getKey();
                Class<?> type = entry.getValue().getReturnType();
                TypeNode typeNode = context.getTypeNodeIntrospector().introspect(this.fullName, name, type, context);
                if (typeNode == null) continue;
                this.getChildren().put(name, typeNode);
            }
        }
        finally {
            context.descreaseNestingLevel();
        }
    }

    @Override
    protected String getDynamicHeaderColumnName() {
        return "__pe:" + this.type.getName();
    }

    @Override
    protected void writeToColumnFamilyRowImpl(Object value, ColumnFamilyRow row, TypeNodeContext context) {
        boolean noPropertiesSet = true;
        for (Map.Entry<String, Method> entry : this.getters.entrySet()) {
            Object propertyValue;
            String propertyName = entry.getKey();
            Method propertyGetter = entry.getValue();
            try {
                propertyValue = context.getTypeNodeIntrospector().getProcedureCache().getterMethodFor(propertyGetter).get(value);
            }
            catch (IllegalArgumentException e) {
                throw new SpaceCassandraTypeIntrospectionException("Failed getting value for property " + propertyName + " from property " + this.fullName, e);
            }
            catch (IllegalAccessException e) {
                throw new SpaceCassandraTypeIntrospectionException("Failed getting value for property " + propertyName + " from property " + this.fullName, e);
            }
            catch (InvocationTargetException e) {
                throw new SpaceCassandraTypeIntrospectionException("Failed getting value for property " + propertyName + " from property " + this.fullName, e);
            }
            if (propertyValue == null) continue;
            noPropertiesSet = false;
            this.writePropertyToColumnFamilyRow(row, propertyName, propertyValue, context);
        }
        if (!context.isDynamic() && noPropertiesSet) {
            row.addColumnData(new ColumnData(true, new DynamicColumnMetadata(this.fullName, context.getTypeNodeIntrospector().getDynamicPropertyValueSerializer())));
        }
    }

    @Override
    public Object readFromColumnFamilyRow(ColumnFamilyRow row, TypeNodeContext context) {
        Object newInstance;
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (TypeNode typeNode : this.getChildren().values()) {
            Object value = typeNode.readFromColumnFamilyRow(row, context);
            if (value == null) continue;
            values.put(typeNode.getName(), value);
        }
        if (values.isEmpty() && !row.getColumns().containsKey(this.fullName)) {
            return null;
        }
        try {
            newInstance = context.getTypeNodeIntrospector().getProcedureCache().constructorFor(this.constructor).newInstance();
        }
        catch (InstantiationException e) {
            throw new SpaceCassandraTypeIntrospectionException("Failed creating instance for property " + this.fullName + " of type " + this.type.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new SpaceCassandraTypeIntrospectionException("Failed creating instance for property " + this.fullName + " of type " + this.type.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new SpaceCassandraTypeIntrospectionException("Failed creating instance for property " + this.fullName + " of type " + this.type.getName(), e);
        }
        for (Map.Entry entry : values.entrySet()) {
            Object value = entry.getValue();
            Method setterMethod = this.setters.get(entry.getKey());
            try {
                context.getTypeNodeIntrospector().getProcedureCache().setterMethodFor(setterMethod).set(newInstance, value);
            }
            catch (IllegalArgumentException e) {
                throw new SpaceCassandraTypeIntrospectionException("Failed setting property value for property: " + (String)entry.getKey() + " of " + this.fullName, e);
            }
            catch (IllegalAccessException e) {
                throw new SpaceCassandraTypeIntrospectionException("Failed setting property value for property: " + (String)entry.getKey() + " of " + this.fullName, e);
            }
            catch (InvocationTargetException e) {
                throw new SpaceCassandraTypeIntrospectionException("Failed setting property value for property: " + (String)entry.getKey() + " of " + this.fullName, e);
            }
        }
        return newInstance;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(-128);
        IOUtils.writeString((ObjectOutput)out, (String)this.name);
        IOUtils.writeString((ObjectOutput)out, (String)this.fullName);
        IOUtils.writeString((ObjectOutput)out, (String)this.type.getName());
        IOUtils.writeObject((ObjectOutput)out, this.getChildren());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.name = IOUtils.readString((ObjectInput)in);
        this.fullName = IOUtils.readString((ObjectInput)in);
        this.type = Class.forName(IOUtils.readString((ObjectInput)in), false, Thread.currentThread().getContextClassLoader());
        Map children = (Map)IOUtils.readObject((ObjectInput)in);
        this.getChildren().putAll(children);
        this.initFields(null);
    }
}

