/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.meta.mapping.node;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.pojo.PojoPropertyInfo;
import com.gigaspaces.internal.metadata.pojo.PojoTypeInfo;
import com.gigaspaces.internal.metadata.pojo.PojoTypeInfoRepository;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.openspaces.persistency.cassandra.error.SpaceCassandraTypeIntrospectionException;
import org.openspaces.persistency.cassandra.meta.ColumnFamilyMetadata;
import org.openspaces.persistency.cassandra.meta.data.ColumnData;
import org.openspaces.persistency.cassandra.meta.data.ColumnFamilyRow;
import org.openspaces.persistency.cassandra.meta.mapping.node.SpaceDocumentTypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.TopLevelTypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.TypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.TypeNodeContext;
import org.openspaces.persistency.cassandra.meta.types.PrimitiveClassUtils;

public class SpaceDocumentTopLevelTypeNode
extends SpaceDocumentTypeNode
implements TopLevelTypeNode {
    private static final long serialVersionUID = 1L;
    public static final byte SERIAL_VER = -128;
    private Class<?> keyType;

    public SpaceDocumentTopLevelTypeNode() {
    }

    public SpaceDocumentTopLevelTypeNode(String typeName, String keyName, Class<?> keyType, Map<String, TypeNode> initialChildren, TypeNodeContext context) {
        super(typeName, null, keyName, initialChildren, context);
        this.keyType = keyType;
    }

    @Override
    public String getKeyName() {
        return this.getName();
    }

    @Override
    public Class<?> getKeyType() {
        return this.keyType;
    }

    @Override
    protected String generateFullName(String parentFullName, String name) {
        return null;
    }

    @Override
    protected boolean shouldSkipEntryWrite(String key, Object value) {
        return this.getKeyName().equals(key) || super.shouldSkipEntryWrite(key, value);
    }

    @Override
    protected void writePropertyToColumnFamilyRow(ColumnFamilyRow row, String propertyName, Object propertyValue, TypeNodeContext context) {
        propertyValue = context.getTypeNodeIntrospector().convertFromSpaceDocumentIfNeeded(propertyValue, this.getChildren().get(propertyName));
        super.writePropertyToColumnFamilyRow(row, propertyName, propertyValue, context);
    }

    @Override
    public SpaceDocument readFromColumnFamilyRow(ColumnFamilyRow row, TypeNodeContext context) {
        ColumnFamilyMetadata metadata = row.getColumnFamilyMetadata();
        SpaceDocument result = super.readFromColumnFamilyRow(row, context);
        Object keyValue = row.getKeyValue();
        result.setProperty(metadata.getKeyName(), keyValue);
        HashMap<String, Object> properties = new HashMap<String, Object>(result.getProperties());
        this.handleDynamicColumns(row, properties, context);
        result.addProperties(properties);
        return result;
    }

    private void handleDynamicColumns(ColumnFamilyRow row, Map<String, Object> properties, TypeNodeContext context) {
        HashMap<String, Object> compoundProperties = new HashMap<String, Object>();
        compoundProperties.put("", properties);
        for (ColumnData dynamicColumn : row.getDynamicColumns()) {
            String propertyName;
            String propertyParentPath;
            String columnName = dynamicColumn.getColumnMetadata().getFullName();
            int lastDotIndex = columnName.lastIndexOf(46);
            if (lastDotIndex == -1) {
                propertyParentPath = "";
                propertyName = columnName;
            } else {
                propertyParentPath = columnName.substring(0, lastDotIndex);
                propertyName = columnName.substring(lastDotIndex + 1);
            }
            Object value = dynamicColumn.getValue();
            value = this.createCompoundColumnIfNecessary(compoundProperties, columnName, value, context);
            Object propertyParent = this.getPropertyParent(compoundProperties, propertyParentPath, context);
            this.addDynamicProperty(propertyName, value, propertyParent, context);
        }
    }

    private Object createCompoundColumnIfNecessary(Map<String, Object> compoundProperties, String columnName, Object value, TypeNodeContext context) {
        if (value instanceof String) {
            String strValue = (String)value;
            if (strValue.startsWith("__sd:")) {
                String typeName = strValue.substring("__sd:".length());
                value = this.createDocumentFromTypeName(compoundProperties, columnName, typeName);
            } else if (strValue.equals("__me:")) {
                HashMap map = new HashMap();
                compoundProperties.put(columnName, map);
                value = map;
            } else if (strValue.startsWith("__pe:")) {
                String typeName = strValue.substring("__pe:".length());
                try {
                    value = this.createPojoFromTypeName(compoundProperties, columnName, typeName, context);
                }
                catch (Exception e) {
                    throw new SpaceCassandraTypeIntrospectionException("Could not create new instance for type name: " + typeName, e);
                }
            }
        }
        return value;
    }

    private SpaceDocument createDocumentFromTypeName(Map<String, Object> compoundProperties, String columnName, String typeName) {
        SpaceDocument document = new SpaceDocument(typeName);
        compoundProperties.put(columnName, document);
        return document;
    }

    private Object createPojoFromTypeName(Map<String, Object> compoundProperties, String columnName, String typeName, TypeNodeContext context) throws Exception {
        Class<?> type = Class.forName(typeName);
        Constructor<?> constructor = type.getConstructor(new Class[0]);
        Object object = context.getTypeNodeIntrospector().getProcedureCache().constructorFor(constructor).newInstance();
        compoundProperties.put(columnName, object);
        return object;
    }

    private Object getPropertyParent(Map<String, Object> compoundProperties, String propertyParentPath, TypeNodeContext context) {
        Object propertyParent = compoundProperties.get(propertyParentPath);
        if (propertyParent == null) {
            String[] tokens;
            StringBuilder currentPath = new StringBuilder();
            Object currentParent = compoundProperties.get(currentPath.toString());
            for (String token : tokens = propertyParentPath.split("\\.")) {
                if (currentPath.length() > 0) {
                    currentPath.append(".");
                }
                currentPath.append(token);
                Object newParent = compoundProperties.get(token);
                if (newParent == null) {
                    if (currentParent instanceof SpaceDocument) {
                        currentParent = ((SpaceDocument)currentParent).getProperty(token);
                    } else if (currentParent instanceof Map) {
                        currentParent = ((Map)currentParent).get(token);
                    } else {
                        PojoTypeInfo pojoTypeInfo = PojoTypeInfoRepository.getPojoTypeInfo(currentParent.getClass());
                        PojoPropertyInfo propertyInfo = pojoTypeInfo.getProperty(token);
                        if (propertyInfo == null || propertyInfo.getGetterMethod() == null) {
                            throw new SpaceCassandraTypeIntrospectionException("Could not find getter method for property " + token + " of type: " + currentParent.getClass(), null);
                        }
                        try {
                            currentParent = context.getTypeNodeIntrospector().getProcedureCache().getterMethodFor(propertyInfo.getGetterMethod()).get(currentParent);
                        }
                        catch (IllegalArgumentException e) {
                            throw new SpaceCassandraTypeIntrospectionException("Failed getting value for property " + token + " of parent: " + currentParent.getClass(), e);
                        }
                        catch (IllegalAccessException e) {
                            throw new SpaceCassandraTypeIntrospectionException("Failed getting value for property " + token + " of parent: " + currentParent.getClass(), e);
                        }
                        catch (InvocationTargetException e) {
                            throw new SpaceCassandraTypeIntrospectionException("Failed getting value for property " + token + " of parent: " + currentParent.getClass(), e);
                        }
                    }
                    if (currentParent == null) {
                        throw new SpaceCassandraTypeIntrospectionException("Could not find value parent node for path: " + currentPath.toString(), null);
                    }
                    compoundProperties.put(currentPath.toString(), currentParent);
                    continue;
                }
                currentParent = newParent;
            }
            propertyParent = currentParent;
        }
        return propertyParent;
    }

    private void addDynamicProperty(String propertyName, Object value, Object propertyParent, TypeNodeContext context) {
        if (propertyParent instanceof SpaceDocument) {
            ((SpaceDocument)propertyParent).setProperty(propertyName, value);
        } else if (propertyParent instanceof Map) {
            ((Map)propertyParent).put(propertyName, value);
        } else {
            PojoTypeInfo pojoTypeInfo = PojoTypeInfoRepository.getPojoTypeInfo(propertyParent.getClass());
            PojoPropertyInfo propertyInfo = pojoTypeInfo.getProperty(propertyName);
            if (propertyInfo == null || propertyInfo.getSetterMethod() == null) {
                throw new SpaceCassandraTypeIntrospectionException("Could not find setter method for property " + propertyName + " of parent: " + propertyParent.getClass(), null);
            }
            try {
                context.getTypeNodeIntrospector().getProcedureCache().setterMethodFor(propertyInfo.getSetterMethod()).set(propertyParent, value);
            }
            catch (IllegalArgumentException e) {
                throw new SpaceCassandraTypeIntrospectionException("Failed setting value for property " + propertyName + " of parent: " + propertyParent.getClass(), e);
            }
            catch (IllegalAccessException e) {
                throw new SpaceCassandraTypeIntrospectionException("Failed setting value for property " + propertyName + " of parent: " + propertyParent.getClass(), e);
            }
            catch (InvocationTargetException e) {
                throw new SpaceCassandraTypeIntrospectionException("Failed setting value for property " + propertyName + " of parent: " + propertyParent.getClass(), e);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(-128);
        IOUtils.writeString((ObjectOutput)out, (String)this.name);
        IOUtils.writeString((ObjectOutput)out, (String)this.fullName);
        IOUtils.writeString((ObjectOutput)out, (String)this.typeName);
        IOUtils.writeString((ObjectOutput)out, (String)this.keyType.getName());
        IOUtils.writeObject((ObjectOutput)out, this.getChildren());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.name = IOUtils.readString((ObjectInput)in);
        this.fullName = IOUtils.readString((ObjectInput)in);
        this.typeName = IOUtils.readString((ObjectInput)in);
        String keyTypeName = IOUtils.readString((ObjectInput)in);
        this.keyType = PrimitiveClassUtils.isPrimitive(keyTypeName) ? PrimitiveClassUtils.getPrimitive(keyTypeName) : Class.forName(keyTypeName, false, Thread.currentThread().getContextClassLoader());
        Map children = (Map)IOUtils.readObject((ObjectInput)in);
        this.getChildren().putAll(children);
    }
}

