/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.meta.mapping.node;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.entry.VirtualEntry;
import java.util.Map;
import org.openspaces.persistency.cassandra.meta.data.ColumnFamilyRow;
import org.openspaces.persistency.cassandra.meta.mapping.node.AbstractCompoundTypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.TypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.TypeNodeContext;

public class SpaceDocumentTypeNode
extends AbstractCompoundTypeNode {
    protected String fullName;
    protected String name;
    protected String typeName;

    public SpaceDocumentTypeNode() {
    }

    public SpaceDocumentTypeNode(String typeName, String parentFullName, String name, Map<String, TypeNode> initialChildren, TypeNodeContext context) {
        this.typeName = typeName;
        this.fullName = this.generateFullName(parentFullName, name);
        this.name = name;
        if (initialChildren != null) {
            this.getChildren().putAll(initialChildren);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public Class<?> getType() {
        return SpaceDocument.class;
    }

    public String getTypeName() {
        return this.typeName;
    }

    protected String generateFullName(String parentFullName, String name) {
        return (parentFullName != null ? parentFullName + "." : "") + name;
    }

    protected boolean shouldSkipEntryWrite(String key, Object value) {
        return value == null;
    }

    @Override
    protected String getDynamicHeaderColumnName() {
        return "__sd:" + this.typeName;
    }

    @Override
    protected void writeToColumnFamilyRowImpl(Object value, ColumnFamilyRow row, TypeNodeContext context) {
        VirtualEntry entry = (VirtualEntry)value;
        for (Map.Entry property : entry.getProperties().entrySet()) {
            Object propertyValue;
            String propertyName = (String)property.getKey();
            if (this.shouldSkipEntryWrite(propertyName, propertyValue = property.getValue())) continue;
            this.writePropertyToColumnFamilyRow(row, propertyName, propertyValue, context);
        }
    }

    public SpaceDocument readFromColumnFamilyRow(ColumnFamilyRow row, TypeNodeContext context) {
        SpaceDocument result = new SpaceDocument(this.getTypeName());
        for (Map.Entry<String, TypeNode> entry : this.getChildren().entrySet()) {
            String name = entry.getKey();
            TypeNode child = entry.getValue();
            Object value = child.readFromColumnFamilyRow(row, context);
            if (value == null) continue;
            result.setProperty(name, value);
        }
        return result;
    }
}

