/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.meta.mapping.node;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.metadata.SpaceDocumentSupport;
import com.gigaspaces.metadata.SpacePropertyDescriptor;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import java.util.HashMap;
import me.prettyprint.hector.api.Serializer;
import org.openspaces.persistency.cassandra.meta.DynamicColumnMetadata;
import org.openspaces.persistency.cassandra.meta.TypedColumnMetadata;
import org.openspaces.persistency.cassandra.meta.mapping.filter.DefaultFlattenedPropertiesFilter;
import org.openspaces.persistency.cassandra.meta.mapping.filter.FlattenedPropertiesFilter;
import org.openspaces.persistency.cassandra.meta.mapping.filter.PojoTypeFlattenPropertiesFilter;
import org.openspaces.persistency.cassandra.meta.mapping.node.CassandraDocumentObjectConverter;
import org.openspaces.persistency.cassandra.meta.mapping.node.PojoTypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.SpaceDocumentTopLevelTypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.SpaceDocumentTypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.TopLevelTypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.TypeNode;
import org.openspaces.persistency.cassandra.meta.mapping.node.TypeNodeContext;
import org.openspaces.persistency.cassandra.meta.types.SerializerProvider;
import org.openspaces.persistency.cassandra.meta.types.dynamic.DynamicPropertySerializer;
import org.openspaces.persistency.cassandra.meta.types.dynamic.PropertyValueSerializer;
import org.openspaces.persistency.cassandra.meta.types.dynamic.PropertyValueSerializerHectorSerializerAdapter;
import org.openspaces.persistency.support.ProcedureCache;

public class TypeNodeIntrospector {
    private final CassandraDocumentObjectConverter documentConverter = new CassandraDocumentObjectConverter();
    private final ProcedureCache procedureCache = new ProcedureCache();
    private final FlattenedPropertiesFilter pojoTypeFilter = new PojoTypeFlattenPropertiesFilter();
    private final FlattenedPropertiesFilter flattenedPropertiesFilter;
    private final Serializer<Object> fixedPropertyValueSerializer;
    private final Serializer<Object> dynamicPropertyValueSerializer;

    public TypeNodeIntrospector(PropertyValueSerializer fixedPropertyValueSerializer, PropertyValueSerializer dynamicPropertyValueSerializer, FlattenedPropertiesFilter flattenedPropertiesFilter) {
        this.fixedPropertyValueSerializer = fixedPropertyValueSerializer == null ? null : new PropertyValueSerializerHectorSerializerAdapter(fixedPropertyValueSerializer);
        this.dynamicPropertyValueSerializer = dynamicPropertyValueSerializer == null ? DynamicPropertySerializer.get() : new PropertyValueSerializerHectorSerializerAdapter(dynamicPropertyValueSerializer);
        this.flattenedPropertiesFilter = flattenedPropertiesFilter == null ? new DefaultFlattenedPropertiesFilter() : flattenedPropertiesFilter;
    }

    public Serializer<Object> getDynamicPropertyValueSerializer() {
        return this.dynamicPropertyValueSerializer;
    }

    public Serializer<Object> getFixedPropertyValueSerializer() {
        return this.fixedPropertyValueSerializer;
    }

    public TopLevelTypeNode introspectTypeDescriptor(SpaceTypeDescriptor typeDescriptor) {
        TypeNodeContext context = new TypeNodeContext(this, true);
        context.increaseNestingLevel();
        String typeName = typeDescriptor.getTypeName();
        String keyName = null;
        Class keyType = null;
        HashMap<String, TypeNode> initialChildren = new HashMap<String, TypeNode>();
        for (int i = 0; i < typeDescriptor.getNumOfFixedProperties(); ++i) {
            SpacePropertyDescriptor propertyDescriptor = typeDescriptor.getFixedProperty(i);
            String name = propertyDescriptor.getName();
            Class type = propertyDescriptor.getType();
            if (typeDescriptor.getIdPropertyName().equals(name)) {
                keyName = name;
                keyType = type;
                continue;
            }
            TypeNode typeNode = this.introspect(null, name, type, context);
            if (typeNode == null) continue;
            initialChildren.put(name, typeNode);
        }
        return new SpaceDocumentTopLevelTypeNode(typeName, keyName, keyType, initialChildren, context);
    }

    public TypeNode introspect(String parentFullName, String name, Object value, TypeNodeContext context) {
        context.setCurrentPropertyContext(parentFullName, name, value.getClass());
        boolean shouldFlatten = this.flattenedPropertiesFilter.shouldFlatten(context);
        if (shouldFlatten && value instanceof SpaceDocument) {
            return this.introspectSpaceDocument(parentFullName, name, ((SpaceDocument)value).getTypeName(), context);
        }
        if (shouldFlatten && this.pojoTypeFilter.shouldFlatten(context)) {
            return this.introspectPojo(parentFullName, name, value.getClass(), context);
        }
        return this.introspectLeafTypeNode(parentFullName, name, value.getClass(), context);
    }

    public TypeNode introspect(String parentFullName, String name, Class<?> type, TypeNodeContext context) {
        context.setCurrentPropertyContext(parentFullName, name, type);
        boolean shouldFlatten = this.flattenedPropertiesFilter.shouldFlatten(context);
        if (shouldFlatten && SpaceDocument.class.isAssignableFrom(type)) {
            return this.introspectSpaceDocument(parentFullName, name, type, context);
        }
        if (shouldFlatten && this.pojoTypeFilter.shouldFlatten(context)) {
            return this.introspectPojo(parentFullName, name, type, context);
        }
        return this.introspectLeafTypeNode(parentFullName, name, type, context);
    }

    private TypeNode introspectSpaceDocument(String parentFullName, String name, Class<?> type, TypeNodeContext context) {
        return null;
    }

    private TypeNode introspectSpaceDocument(String parentFullName, String name, String typeName, TypeNodeContext context) {
        return new SpaceDocumentTypeNode(typeName, parentFullName, name, null, context);
    }

    private TypeNode introspectPojo(String parentFullName, String name, Class<?> type, TypeNodeContext context) {
        return new PojoTypeNode(parentFullName, name, type, context);
    }

    private TypeNode introspectLeafTypeNode(String parentFullName, String name, Class<?> type, TypeNodeContext context) {
        if (context.isDynamic() && context.isUseDynamicPropertySerializerForDynamicColumns()) {
            return new DynamicColumnMetadata(parentFullName, name, this.dynamicPropertyValueSerializer);
        }
        Serializer<Object> serializer = null;
        if (!SerializerProvider.isCommonJavaType(type)) {
            serializer = this.fixedPropertyValueSerializer;
        }
        return new TypedColumnMetadata(parentFullName, name, type, context, serializer);
    }

    public Object convertFromSpaceDocumentIfNeeded(Object value, TypeNode typeNode) {
        if (!SerializerProvider.isCommonJavaType(value.getClass()) && typeNode != null && !(typeNode instanceof SpaceDocumentTypeNode)) {
            value = this.documentConverter.fromDocumentIfNeeded(value, SpaceDocumentSupport.CONVERT, typeNode.getType());
        }
        return value;
    }

    public ProcedureCache getProcedureCache() {
        return this.procedureCache;
    }
}

