/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.meta.types;

import java.nio.ByteBuffer;
import me.prettyprint.cassandra.serializers.AbstractSerializer;
import me.prettyprint.hector.api.Serializer;
import org.openspaces.persistency.cassandra.meta.types.SerializerProvider;

public class CustomTypeInferringSerializer<T>
extends AbstractSerializer<T>
implements Serializer<T> {
    private static final CustomTypeInferringSerializer INSTANCE = new CustomTypeInferringSerializer();

    public static <T> CustomTypeInferringSerializer<T> get() {
        return INSTANCE;
    }

    public ByteBuffer toByteBuffer(T obj) {
        return SerializerProvider.getSerializer(obj.getClass()).toByteBuffer(obj);
    }

    public T fromByteBuffer(ByteBuffer byteBuffer) {
        throw new IllegalStateException("The type inferring serializer can only be used for data going to the database, and not data coming from the database");
    }
}

