/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.meta.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.prettyprint.cassandra.serializers.BigDecimalSerializer;
import me.prettyprint.cassandra.serializers.BigIntegerSerializer;
import me.prettyprint.cassandra.serializers.BooleanSerializer;
import me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import me.prettyprint.cassandra.serializers.BytesArraySerializer;
import me.prettyprint.cassandra.serializers.CharSerializer;
import me.prettyprint.cassandra.serializers.DateSerializer;
import me.prettyprint.cassandra.serializers.DoubleTypeSerializer;
import me.prettyprint.cassandra.serializers.FloatTypeSerializer;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.ObjectSerializer;
import me.prettyprint.cassandra.serializers.ShortSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.serializers.UUIDSerializer;
import me.prettyprint.hector.api.Serializer;
import org.openspaces.persistency.cassandra.meta.types.ByteSerializer;

public class SerializerProvider {
    private static final Map<Class<?>, Serializer<?>> serializers = new HashMap();
    private static final Serializer<Object> OBJECT_SERIALIZER = new ObjectSerializer(SerializerProvider.class.getClassLoader());

    public static <T> Serializer<T> getSerializer(Class<?> type) {
        Object serializer = serializers.get(type);
        if (serializer == null) {
            serializer = SerializerProvider.getObjectSerializer();
        }
        return serializer;
    }

    public static Serializer<Object> getObjectSerializer() {
        return OBJECT_SERIALIZER;
    }

    public static boolean isCommonJavaType(Class<?> type) {
        return SerializerProvider.getSerializer(type) != SerializerProvider.getObjectSerializer();
    }

    static {
        serializers.put(Boolean.TYPE, (Serializer<?>)BooleanSerializer.get());
        serializers.put(Boolean.class, (Serializer<?>)BooleanSerializer.get());
        serializers.put(Byte.TYPE, ByteSerializer.get());
        serializers.put(Byte.class, ByteSerializer.get());
        serializers.put(Character.TYPE, (Serializer<?>)CharSerializer.get());
        serializers.put(Character.class, (Serializer<?>)CharSerializer.get());
        serializers.put(Short.TYPE, (Serializer<?>)ShortSerializer.get());
        serializers.put(Short.class, (Serializer<?>)ShortSerializer.get());
        serializers.put(Integer.TYPE, (Serializer<?>)IntegerSerializer.get());
        serializers.put(Integer.class, (Serializer<?>)IntegerSerializer.get());
        serializers.put(Long.TYPE, (Serializer<?>)LongSerializer.get());
        serializers.put(Long.class, (Serializer<?>)LongSerializer.get());
        serializers.put(Float.TYPE, (Serializer<?>)FloatTypeSerializer.get());
        serializers.put(Float.class, (Serializer<?>)FloatTypeSerializer.get());
        serializers.put(Double.TYPE, (Serializer<?>)DoubleTypeSerializer.get());
        serializers.put(Double.class, (Serializer<?>)DoubleTypeSerializer.get());
        serializers.put(BigInteger.class, (Serializer<?>)BigIntegerSerializer.get());
        serializers.put(BigDecimal.class, (Serializer<?>)BigDecimalSerializer.get());
        serializers.put(byte[].class, (Serializer<?>)BytesArraySerializer.get());
        serializers.put(ByteBuffer.class, (Serializer<?>)ByteBufferSerializer.get());
        serializers.put(Date.class, (Serializer<?>)DateSerializer.get());
        serializers.put(String.class, (Serializer<?>)StringSerializer.get());
        serializers.put(UUID.class, (Serializer<?>)UUIDSerializer.get());
    }
}

