/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.meta.types;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import me.prettyprint.hector.api.ddl.ComparatorType;
import org.openspaces.persistency.cassandra.meta.types.SerializerProvider;

public class ValidatorClassInferer {
    public static final ComparatorType INT32TYPE = ValidatorClassInferer.type("Int32Type");
    public static final ComparatorType DATETYPE = ValidatorClassInferer.type("DateType");
    public static final ComparatorType BOOLEANTYPE = ValidatorClassInferer.type("BooleanType");
    public static final ComparatorType FLOATTYPE = ValidatorClassInferer.type("FloatType");
    public static final ComparatorType DOUBLETYPE = ValidatorClassInferer.type("DoubleType");
    private static final Map<Class<?>, String> validators = new HashMap();

    private static ComparatorType type(String name) {
        return ComparatorType.getByClassName((String)("org.apache.cassandra.db.marshal." + name));
    }

    public static String infer(Class<?> type) {
        String validationClass = validators.get(type);
        if (validationClass == null) {
            validationClass = SerializerProvider.getSerializer(type).getComparatorType().getClassName();
        }
        return validationClass;
    }

    public static String getBytesTypeValidationClass() {
        return ComparatorType.BYTESTYPE.getClassName();
    }

    public static boolean isBytesType(Class<?> type) {
        return ComparatorType.BYTESTYPE.getClassName().equals(ValidatorClassInferer.infer(type));
    }

    static {
        validators.put(Boolean.TYPE, BOOLEANTYPE.getClassName());
        validators.put(Boolean.class, BOOLEANTYPE.getClassName());
        validators.put(Integer.TYPE, INT32TYPE.getClassName());
        validators.put(Integer.class, INT32TYPE.getClassName());
        validators.put(Float.TYPE, FLOATTYPE.getClassName());
        validators.put(Float.class, FLOATTYPE.getClassName());
        validators.put(Double.TYPE, DOUBLETYPE.getClassName());
        validators.put(Double.class, DOUBLETYPE.getClassName());
        validators.put(Date.class, DATETYPE.getClassName());
    }
}

