/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.meta.types.dynamic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import org.openspaces.persistency.cassandra.error.SpaceCassandraSerializationException;
import org.openspaces.persistency.cassandra.meta.types.dynamic.PropertyValueSerializer;

public class DynamicPropertyValueSerializer
implements PropertyValueSerializer {
    private static final DynamicPropertyValueSerializer INSTANCE = new DynamicPropertyValueSerializer();
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte TYPE_CHAR = -128;
    private static final byte TYPE_BYTE = -127;
    private static final byte TYPE_STRING = -126;
    private static final byte TYPE_BOOLEAN = -125;
    private static final byte TYPE_INT = -124;
    private static final byte TYPE_LONG = -123;
    private static final byte TYPE_FLOAT = -122;
    private static final byte TYPE_DOUBLE = -121;
    private static final byte TYPE_SHORT = -120;
    private static final byte TYPE_UUID = -119;
    private static final byte TYPE_DATE = -118;
    private static final byte TYPE_BIGINT = -117;
    private static final byte TYPE_BIGDECIMAL = -116;
    private static final byte TYPE_BYTEARRAY = -115;
    private static final byte TYPE_OBJECT = 127;
    private static final Map<Class<?>, Byte> typeCodes = new HashMap();

    public static DynamicPropertyValueSerializer get() {
        return INSTANCE;
    }

    private DynamicPropertyValueSerializer() {
    }

    private byte type(Object value) {
        Byte type = typeCodes.get(value.getClass());
        if (type == null) {
            type = 127;
        }
        return type;
    }

    @Override
    public ByteBuffer toByteBuffer(Object obj) {
        switch (this.type(obj)) {
            case -128: {
                return this.charToByteBuffer((Character)obj);
            }
            case -127: {
                return this.byteToByteBuffer((Byte)obj);
            }
            case -126: {
                return this.stringToByteBuffer((String)obj);
            }
            case -125: {
                return this.booleanToByteBuffer((Boolean)obj);
            }
            case -124: {
                return this.intToByteBuffer((Integer)obj);
            }
            case -123: {
                return this.longToByteBuffer((Long)obj);
            }
            case -122: {
                return this.floatToByteBuffer((Float)obj);
            }
            case -121: {
                return this.doubleToByteBuffer((Double)obj);
            }
            case -120: {
                return this.shortToByteBuffer((Short)obj);
            }
            case -119: {
                return this.UUIDToByteBuffer((UUID)obj);
            }
            case -118: {
                return this.dateToByteBuffer((Date)obj);
            }
            case -117: {
                return this.bigIntToByteBuffer((BigInteger)obj);
            }
            case -116: {
                return this.bigDecimalToByteBuffer((BigDecimal)obj);
            }
            case -115: {
                return this.byteArrayToByteBuffer((byte[])obj);
            }
        }
        return this.objectToByteBuffer(obj);
    }

    @Override
    public Object fromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null || !byteBuffer.hasRemaining()) {
            return null;
        }
        switch (byteBuffer.get()) {
            case -128: {
                return Character.valueOf(UTF_8.decode(byteBuffer).toString().charAt(0));
            }
            case -127: {
                return byteBuffer.get();
            }
            case -126: {
                return UTF_8.decode(byteBuffer).toString();
            }
            case -125: {
                return byteBuffer.get() == 1;
            }
            case -124: {
                return byteBuffer.getInt();
            }
            case -123: {
                return byteBuffer.getLong();
            }
            case -122: {
                return Float.valueOf(byteBuffer.getFloat());
            }
            case -121: {
                return byteBuffer.getDouble();
            }
            case -120: {
                return byteBuffer.getShort();
            }
            case -119: {
                return new UUID(byteBuffer.getLong(), byteBuffer.getLong());
            }
            case -118: {
                return new Date(byteBuffer.getLong());
            }
            case -117: {
                return this.byteBufferToBigInteger(byteBuffer);
            }
            case -116: {
                return this.byteBufferToBigDecimal(byteBuffer);
            }
            case -115: {
                return this.byteBufferToByteArray(byteBuffer);
            }
        }
        return this.byteBuffertoObject(byteBuffer);
    }

    private ByteBuffer booleanToByteBuffer(Boolean value) {
        byte[] bytes = new byte[]{-125, value != false ? (byte)1 : 0};
        return ByteBuffer.wrap(bytes);
    }

    private ByteBuffer byteToByteBuffer(Byte value) {
        byte[] bytes = new byte[]{-127, value};
        return ByteBuffer.wrap(bytes);
    }

    private ByteBuffer charToByteBuffer(Character value) {
        return this.stringToByteBuffer(new String(new char[]{value.charValue()}), (byte)-128);
    }

    private ByteBuffer stringToByteBuffer(String value) {
        return this.stringToByteBuffer(value, (byte)-126);
    }

    private ByteBuffer stringToByteBuffer(String value, byte type) {
        try {
            byte[] stringUTFBytes = value.getBytes(UTF_8.name());
            byte[] bytes = new byte[1 + stringUTFBytes.length];
            bytes[0] = type;
            System.arraycopy(stringUTFBytes, 0, bytes, 1, stringUTFBytes.length);
            return ByteBuffer.wrap(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new SpaceCassandraSerializationException("Failed serializing string: " + value, e);
        }
    }

    private ByteBuffer shortToByteBuffer(Short value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(3);
        byteBuffer.put(0, (byte)-120);
        byteBuffer.putShort(1, value);
        byteBuffer.rewind();
        return byteBuffer;
    }

    private ByteBuffer intToByteBuffer(Integer value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(5);
        byteBuffer.put(0, (byte)-124);
        byteBuffer.putInt(1, value);
        byteBuffer.rewind();
        return byteBuffer;
    }

    private ByteBuffer dateToByteBuffer(Date value) {
        return this.longToByteBuffer(value.getTime(), (byte)-118);
    }

    private ByteBuffer longToByteBuffer(Long value) {
        return this.longToByteBuffer(value, (byte)-123);
    }

    private ByteBuffer longToByteBuffer(Long value, byte type) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(9);
        byteBuffer.put(0, type);
        byteBuffer.putLong(1, value);
        byteBuffer.rewind();
        return byteBuffer;
    }

    private ByteBuffer floatToByteBuffer(Float value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(5);
        byteBuffer.put(0, (byte)-122);
        byteBuffer.putFloat(1, value.floatValue());
        byteBuffer.rewind();
        return byteBuffer;
    }

    private ByteBuffer doubleToByteBuffer(Double value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(9);
        byteBuffer.put(0, (byte)-121);
        byteBuffer.putDouble(1, value);
        byteBuffer.rewind();
        return byteBuffer;
    }

    private ByteBuffer UUIDToByteBuffer(UUID value) {
        int i;
        long msb = value.getMostSignificantBits();
        long lsb = value.getLeastSignificantBits();
        byte[] bytes = new byte[17];
        bytes[0] = -119;
        for (i = 0; i < 8; ++i) {
            bytes[i + 1] = (byte)(msb >>> 8 * (7 - i));
        }
        for (i = 8; i < 16; ++i) {
            bytes[i + 1] = (byte)(lsb >>> 8 * (7 - i));
        }
        return ByteBuffer.wrap(bytes);
    }

    private BigInteger byteBufferToBigInteger(ByteBuffer byteBuffer) {
        int length = byteBuffer.remaining();
        byte[] bytes = new byte[length];
        byteBuffer.get(bytes);
        return new BigInteger(bytes);
    }

    private ByteBuffer bigIntToByteBuffer(BigInteger value) {
        byte[] bigIntBytes = value.toByteArray();
        byte[] bytes = new byte[1 + bigIntBytes.length];
        bytes[0] = -117;
        System.arraycopy(bigIntBytes, 0, bytes, 1, bigIntBytes.length);
        return ByteBuffer.wrap(bytes);
    }

    private BigDecimal byteBufferToBigDecimal(ByteBuffer byteBuffer) {
        int scale = byteBuffer.getInt();
        byte[] bigIntegerBytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bigIntegerBytes, 0, byteBuffer.remaining());
        BigInteger bigInteger = new BigInteger(bigIntegerBytes);
        return new BigDecimal(bigInteger, scale);
    }

    private ByteBuffer bigDecimalToByteBuffer(BigDecimal value) {
        byte[] bigIntBytes = value.unscaledValue().toByteArray();
        byte[] scaleBytes = IntegerSerializer.get().toBytes((Object)value.scale());
        byte[] bytes = new byte[1 + scaleBytes.length + bigIntBytes.length];
        bytes[0] = -116;
        System.arraycopy(scaleBytes, 0, bytes, 1, scaleBytes.length);
        System.arraycopy(bigIntBytes, 0, bytes, 1 + scaleBytes.length, bigIntBytes.length);
        return ByteBuffer.wrap(bytes);
    }

    private Object byteBufferToByteArray(ByteBuffer byteBuffer) {
        int length = byteBuffer.getInt();
        byte[] result = new byte[length];
        byteBuffer.get(result);
        return result;
    }

    private ByteBuffer byteArrayToByteBuffer(byte[] value) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(5 + value.length);
        byteBuffer.put((byte)-115);
        byteBuffer.putInt(value.length);
        byteBuffer.put(value);
        byteBuffer.rewind();
        return byteBuffer;
    }

    private Object byteBuffertoObject(ByteBuffer byteBuffer) {
        try {
            int length = byteBuffer.remaining();
            ByteArrayInputStream bais = new ByteArrayInputStream(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), length);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object object = ois.readObject();
            byteBuffer.position(byteBuffer.position() + (length - ois.available()));
            ois.close();
            return object;
        }
        catch (Exception e) {
            throw new SpaceCassandraSerializationException("Failed deserializing object", e);
        }
    }

    private ByteBuffer objectToByteBuffer(Object value) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            oos.close();
            byte[] objectBytes = baos.toByteArray();
            byte[] bytes = new byte[1 + objectBytes.length];
            bytes[0] = 127;
            System.arraycopy(objectBytes, 0, bytes, 1, objectBytes.length);
            return ByteBuffer.wrap(bytes);
        }
        catch (IOException e) {
            throw new SpaceCassandraSerializationException("Failed serializing object " + value, e);
        }
    }

    static {
        typeCodes.put(Boolean.class, (byte)-125);
        typeCodes.put(Byte.class, (byte)-127);
        typeCodes.put(Character.class, (byte)-128);
        typeCodes.put(Short.class, (byte)-120);
        typeCodes.put(Integer.class, (byte)-124);
        typeCodes.put(Long.class, (byte)-123);
        typeCodes.put(Float.class, (byte)-122);
        typeCodes.put(Double.class, (byte)-121);
        typeCodes.put(String.class, (byte)-126);
        typeCodes.put(UUID.class, (byte)-119);
        typeCodes.put(Date.class, (byte)-118);
        typeCodes.put(BigInteger.class, (byte)-117);
        typeCodes.put(BigDecimal.class, (byte)-116);
        typeCodes.put(byte[].class, (byte)-115);
    }
}

