/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.persistency.cassandra.pool;

import com.j_spaces.kernel.pool.IResource;
import com.j_spaces.kernel.pool.Resource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.persistency.cassandra.error.SpaceCassandraDataSourceException;

public class ConnectionResource
extends Resource
implements IResource {
    private static final Log logger = LogFactory.getLog(ConnectionResource.class);
    private final DataSource dataSource;
    private boolean closed;
    private Connection connection;

    public ConnectionResource(Connection connection, DataSource dataSource) {
        this.connection = connection;
        this.dataSource = dataSource;
    }

    public void clear() {
        if (!this.isFromPool()) {
            this.closeUnderlyingConnection();
        }
    }

    public Connection getConnection() {
        if (this.closed) {
            throw new SpaceCassandraDataSourceException("Resource already closed");
        }
        if (this.connection == null) {
            try {
                this.connection = this.dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new SpaceCassandraDataSourceException("Could not create a new connection", e);
            }
        }
        return this.connection;
    }

    public void closeCurrentConnection() {
        if (this.connection != null) {
            this.closeUnderlyingConnection();
            this.connection = null;
        }
    }

    private void closeUnderlyingConnection() {
        block2: {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn((Object)"Failed closing jdbc connection", (Throwable)e);
            }
        }
    }

    public void close() {
        this.closeUnderlyingConnection();
        this.closed = true;
    }
}

