/*
 * Decompiled with CFR 0.152.
 */
package org.pf.db.util;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceProxy
implements DataSource {
    private String dbUrl = null;
    private String dbUserid = null;
    private String dbPassword = null;
    private Connection dbConnection = null;
    private DataSource dataSource = null;

    protected String getDbUrl() {
        return this.dbUrl;
    }

    protected void setDbUrl(String newValue) {
        this.dbUrl = newValue;
    }

    protected String getDbUserid() {
        return this.dbUserid;
    }

    protected void setDbUserid(String newValue) {
        this.dbUserid = newValue;
    }

    protected String getDbPassword() {
        return this.dbPassword;
    }

    protected void setDbPassword(String newValue) {
        this.dbPassword = newValue;
    }

    protected Connection getDbConnection() {
        return this.dbConnection;
    }

    protected void setDbConnection(Connection newValue) {
        this.dbConnection = newValue;
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected void setDataSource(DataSource newValue) {
        this.dataSource = newValue;
    }

    public DataSourceProxy(Connection conn) {
        this.setDbConnection(conn);
    }

    public DataSourceProxy(String url, String username, String password) {
        this.setDbUrl(url);
        this.setDbUserid(username);
        this.setDbPassword(password);
    }

    public DataSourceProxy(String url) {
        this(url, null, null);
    }

    public DataSourceProxy(DataSource dataSource, String username, String password) {
        this.setDataSource(dataSource);
        this.setDbUserid(username);
        this.setDbPassword(password);
    }

    public DataSourceProxy(DataSource dataSource) {
        this(dataSource, null, null);
    }

    public Connection getConnection() throws SQLException {
        if (this.hasConnection()) {
            return this.getDbConnection();
        }
        if (this.hasDataSource()) {
            return this.getDataSourceConnection();
        }
        if (this.getDbUserid() == null || this.getDbPassword() == null) {
            return DriverManager.getConnection(this.getDbUrl());
        }
        return DriverManager.getConnection(this.getDbUrl(), this.getDbUserid(), this.getDbPassword());
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (this.hasDataSource()) {
            return this.getDataSource().getConnection(username, password);
        }
        return DriverManager.getConnection(this.getDbUrl(), username, password);
    }

    public int getLoginTimeout() throws SQLException {
        if (this.hasDataSource()) {
            return this.getDataSource().getLoginTimeout();
        }
        return DriverManager.getLoginTimeout();
    }

    public PrintWriter getLogWriter() throws SQLException {
        if (this.hasDataSource()) {
            return this.getDataSource().getLogWriter();
        }
        return DriverManager.getLogWriter();
    }

    public void setLoginTimeout(int timeout) throws SQLException {
        if (this.hasDataSource()) {
            this.getDataSource().setLoginTimeout(timeout);
        } else {
            DriverManager.setLoginTimeout(timeout);
        }
    }

    public void setLogWriter(PrintWriter writer) throws SQLException {
        if (this.hasDataSource()) {
            this.getDataSource().setLogWriter(writer);
        } else {
            DriverManager.setLogWriter(writer);
        }
    }

    protected boolean hasDataSource() {
        return this.getDataSource() != null;
    }

    protected boolean hasConnection() {
        return this.getDbConnection() != null;
    }

    protected Connection getDataSourceConnection() throws SQLException {
        if (this.getDbUserid() == null || this.getDbPassword() == null) {
            return this.getDataSource().getConnection();
        }
        return this.getDataSource().getConnection(this.getDbUserid(), this.getDbPassword());
    }
}

