/*
 * Decompiled with CFR 0.152.
 */
package org.pf.db.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.pf.db.LoggerProvider;
import org.pf.db.util.ObjectIdentifierGenerator;
import org.pf.logging.Logger;

public class ObjectIdentifierDB
extends ObjectIdentifierGenerator {
    protected static final String OID_TABLE_NAME = "OIDADMIN";
    protected static final String OID_CN_CATEGORY = "CATEGORY";
    protected static final String OID_CN_NEXTID = "NEXTID";
    protected static final String OID_CN_BLOCKSIZE = "BLOCKSIZE";
    protected static final int INITIAL_BLOCKSIZE = 1;
    private DataSource dataSource = null;
    private String category = "$DEFAULT";
    protected boolean tableInitialized = false;
    private String select = null;
    private String selectCategory = null;
    private String selectAny = null;
    private String update = null;
    private String qualifier = null;
    private long lastPrefetchedId = 0L;

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected void setDataSource(DataSource newValue) {
        this.dataSource = newValue;
    }

    protected String getCategory() {
        return this.category;
    }

    protected void setCategory(String newValue) {
        this.category = newValue;
    }

    protected String getSelect() {
        return this.select;
    }

    protected void setSelect(String newValue) {
        this.select = newValue;
    }

    protected String getSelectCategory() {
        return this.selectCategory;
    }

    protected void setSelectCategory(String newValue) {
        this.selectCategory = newValue;
    }

    protected String getSelectAny() {
        return this.selectAny;
    }

    protected void setSelectAny(String newValue) {
        this.selectAny = newValue;
    }

    protected String getUpdate() {
        return this.update;
    }

    protected void setUpdate(String newValue) {
        this.update = newValue;
    }

    protected String getQualifier() {
        return this.qualifier;
    }

    protected void setQualifier(String newValue) {
        this.qualifier = newValue;
    }

    protected long getLastPrefetchedId() {
        return this.lastPrefetchedId;
    }

    protected void setLastPrefetchedId(long newValue) {
        this.lastPrefetchedId = newValue;
    }

    public ObjectIdentifierDB(DataSource ds) {
        this(null, ds);
    }

    public ObjectIdentifierDB(String tableQualifier, DataSource ds) {
        this.setDataSource(ds);
        this.setQualifier(tableQualifier);
    }

    public ObjectIdentifierDB(DataSource ds, String categoryName) {
        this(ds);
        if (categoryName != null && categoryName.length() > 0) {
            this.setCategory(categoryName);
        }
    }

    public ObjectIdentifierDB(String tableQualifier, DataSource ds, String categoryName) {
        this(tableQualifier, ds);
        if (categoryName != null && categoryName.length() > 0) {
            this.setCategory(categoryName);
        }
    }

    protected long getNextId() {
        if (this.getNextAvailableId() > this.getLastPrefetchedId()) {
            this.loadNextIdFromDB();
        }
        return this.getNextAvailableId();
    }

    protected void loadNextIdFromDB() {
        long id = 0L;
        if (this.tableInitialized()) {
            id = this.idFromDB();
            this.setNextAvailableId(id);
        }
    }

    protected void setNextId(long id) {
        if (id > this.getLastPrefetchedId()) {
            this.loadNextIdFromDB();
        } else {
            this.setNextAvailableId(id);
        }
    }

    protected void setNextIdInDB(Connection conn, long id) throws SQLException {
        PreparedStatement statement = null;
        statement = conn.prepareStatement(this.sqlUpdateNextId());
        statement.setString(1, Long.toString(id));
        statement.execute();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean tableInitialized() {
        Connection conn = null;
        Statement statement = null;
        String action = null;
        boolean ok = false;
        if (this.tableInitialized) {
            return true;
        }
        try {
            try {
                action = "Reading";
                conn = this.getDbConnection();
                ok = this.checkTableExists(conn);
                if (!ok) {
                    action = "Creating";
                    this.createOidTable(conn);
                    ok = true;
                }
                if (ok && !(ok = this.checkCategoryRowExists(conn))) {
                    action = "Init";
                    this.createRowForCategory(conn);
                    ok = true;
                }
                this.tableInitialized = ok;
            }
            catch (SQLException ex) {
                this.reportSQLException(String.valueOf(action) + " OID table failed.", ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeStatement(statement);
            this.closeConnection(conn);
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.closeStatement(statement);
            this.closeConnection(conn);
            return this.tableInitialized;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long idFromDB() {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet result = null;
        String idStr = null;
        long id = 0L;
        int blockSize = 0;
        long nextBlockStart = 0L;
        try {
            try {
                conn = this.getDbConnection();
                statement = conn.prepareStatement(this.sqlSelectNextId());
                result = statement.executeQuery();
                if (result.next()) {
                    idStr = result.getString(OID_CN_NEXTID);
                    id = Long.parseLong(idStr);
                    blockSize = result.getInt(OID_CN_BLOCKSIZE);
                    if (blockSize <= 0) {
                        blockSize = 1;
                    }
                    nextBlockStart = id + (long)blockSize;
                    this.setNextIdInDB(conn, nextBlockStart);
                    this.setLastPrefetchedId(nextBlockStart - 1L);
                }
            }
            catch (SQLException ex) {
                this.reportSQLException("Reading OID table failed.", ex);
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.closeStatement(statement);
            this.closeConnection(conn);
            throw throwable;
        }
        {
            Object var11_11 = null;
            this.closeStatement(statement);
            this.closeConnection(conn);
            return id;
        }
    }

    protected String sqlCreateOidTable() {
        StringBuffer buffer = new StringBuffer(200);
        buffer.append("CREATE TABLE ");
        buffer.append(this.getTableName());
        buffer.append("(\n  ");
        buffer.append(OID_CN_CATEGORY);
        buffer.append("\t VARCHAR(50),\n  ");
        buffer.append(OID_CN_NEXTID);
        buffer.append("\t VARCHAR(50),\n");
        buffer.append(OID_CN_BLOCKSIZE);
        buffer.append("\t INTEGER )\n");
        return buffer.toString();
    }

    protected String sqlInsertCategoryRow(String cat) {
        StringBuffer buffer = new StringBuffer(200);
        buffer.append("INSERT INTO ");
        buffer.append(this.getTableName());
        buffer.append(" VALUES ( '");
        buffer.append(cat);
        buffer.append("', '");
        buffer.append(Long.toString(1L));
        buffer.append("', ");
        buffer.append(1);
        buffer.append(" )");
        return buffer.toString();
    }

    protected String sqlUpdateNextId() {
        if (this.getUpdate() == null) {
            StringBuffer buffer = new StringBuffer(200);
            buffer.append("UPDATE ");
            buffer.append(this.getTableName());
            buffer.append(" SET ");
            buffer.append(OID_CN_NEXTID);
            buffer.append("=? WHERE ");
            buffer.append(OID_CN_CATEGORY);
            buffer.append(" = '");
            buffer.append(this.getCategory());
            buffer.append("'");
            this.setUpdate(buffer.toString());
        }
        return this.getUpdate();
    }

    protected String sqlSelectNextId() {
        if (this.getSelect() == null) {
            StringBuffer buffer = new StringBuffer(200);
            buffer.append("SELECT ");
            buffer.append(OID_CN_NEXTID);
            buffer.append(", ");
            buffer.append(OID_CN_BLOCKSIZE);
            buffer.append(" FROM ");
            buffer.append(this.getTableName());
            buffer.append(" WHERE ");
            buffer.append(OID_CN_CATEGORY);
            buffer.append(" = '");
            buffer.append(this.getCategory());
            buffer.append("'");
            this.setSelect(buffer.toString());
        }
        return this.getSelect();
    }

    protected String sqlSelectCategory() {
        if (this.getSelectCategory() == null) {
            StringBuffer buffer = new StringBuffer(200);
            buffer.append("SELECT ");
            buffer.append(OID_CN_CATEGORY);
            buffer.append(" FROM ");
            buffer.append(this.getTableName());
            buffer.append(" WHERE ");
            buffer.append(OID_CN_CATEGORY);
            buffer.append(" = '");
            buffer.append(this.getCategory());
            buffer.append("'");
            this.setSelectCategory(buffer.toString());
        }
        return this.getSelectCategory();
    }

    protected String sqlSelectAny() {
        if (this.getSelectAny() == null) {
            StringBuffer buffer = new StringBuffer(200);
            buffer.append("SELECT ");
            buffer.append(OID_CN_CATEGORY);
            buffer.append(" FROM ");
            buffer.append(this.getTableName());
            this.setSelectAny(buffer.toString());
        }
        return this.getSelectAny();
    }

    protected String categoryString() {
        StringBuffer buffer = new StringBuffer(200);
        buffer.append("'");
        buffer.append(this.getCategory());
        buffer.append("'");
        return buffer.toString();
    }

    protected void createOidTable(Connection conn) throws SQLException {
        Statement statement = conn.createStatement();
        statement.execute(this.sqlCreateOidTable());
        conn.commit();
        this.createRowForCategory(conn);
    }

    protected void createRowForCategory(Connection conn) throws SQLException {
        Statement statement = conn.createStatement();
        statement.execute(this.sqlInsertCategoryRow(this.getCategory()));
        conn.commit();
    }

    protected boolean checkTableExists(Connection conn) {
        try {
            this.anyRowExists(conn, this.sqlSelectAny());
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    protected boolean checkCategoryRowExists(Connection conn) {
        try {
            return this.anyRowExists(conn, this.sqlSelectCategory());
        }
        catch (SQLException ex) {
            return false;
        }
    }

    protected boolean anyRowExists(Connection conn, String sql) throws SQLException {
        PreparedStatement statement = null;
        ResultSet result = null;
        boolean found = false;
        statement = conn.prepareStatement(sql);
        result = statement.executeQuery();
        found = result.next();
        result.close();
        return found;
    }

    protected void reportSQLException(String msg, SQLException ex) {
        this.logger().logError(msg, ex);
    }

    protected String getTableName() {
        if (this.getQualifier() == null) {
            return OID_TABLE_NAME;
        }
        return String.valueOf(this.getQualifier()) + "." + OID_TABLE_NAME;
    }

    protected Connection getDbConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    protected void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                this.logger().logException(ex);
            }
        }
    }

    protected void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                this.logger().logException(ex);
            }
        }
    }

    protected Logger logger() {
        return LoggerProvider.getLogger();
    }
}

