/*
 * Decompiled with CFR 0.152.
 */
package org.pf.db.util;

import org.pf.db.util.ObjectIdentifierProducer;
import org.pf.text.StringUtil;

public class ObjectIdentifierGenerator
implements ObjectIdentifierProducer {
    protected static final char PAD_CHAR = '0';
    protected static final long INITIAL_VALUE = 1L;
    private int length = 10;
    private long nextAvailableId = 1L;

    protected long getNextAvailableId() {
        return this.nextAvailableId;
    }

    protected void setNextAvailableId(long newValue) {
        this.nextAvailableId = newValue;
    }

    public ObjectIdentifierGenerator() {
    }

    public ObjectIdentifierGenerator(int idLength) {
        this();
        this.setLength(idLength);
    }

    public ObjectIdentifierGenerator(long startId, int idLength) {
        this(idLength);
        if (startId >= 0L) {
            this.setNextAvailableId(startId);
        }
    }

    public String newIdentifier() {
        return this.leftPad(this.nextStrId());
    }

    public long nextIdentifier() {
        long id = this.getNextId();
        this.setNextId(id + 1L);
        return id;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int newValue) {
        if (newValue > 0) {
            this.length = newValue;
        }
    }

    protected String leftPad(String id) {
        return StringUtil.current().leftPadCh(id, this.getLength(), this.getPadChar());
    }

    protected char getPadChar() {
        return '0';
    }

    protected String nextStrId() {
        long id = this.nextIdentifier();
        return Long.toString(id);
    }

    protected long getNextId() {
        return this.getNextAvailableId();
    }

    protected void setNextId(long id) {
        this.setNextAvailableId(id);
    }
}

