/*
 * Decompiled with CFR 0.152.
 */
package org.pf.db.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class SQLExecutor {
    private DataSource dataSource = null;
    private Connection connection = null;

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected void setDataSource(DataSource newValue) {
        this.dataSource = newValue;
    }

    protected Connection connection() {
        return this.connection;
    }

    protected void connection(Connection newValue) {
        this.connection = newValue;
    }

    public SQLExecutor(DataSource aDataSource) {
        if (aDataSource == null) {
            throw new IllegalArgumentException("Datasource in SQLExecutor constructor is null");
        }
        this.setDataSource(aDataSource);
    }

    public PreparedStatement prepareWriteStatement(String sql) throws SQLException {
        return this.getConnection().prepareStatement(sql);
    }

    public int executeWriteStatement(PreparedStatement statement) throws SQLException {
        Connection conn = this.getConnection();
        if (conn != null) {
            return statement.executeUpdate();
        }
        return 0;
    }

    public int execute(String sql) throws SQLException {
        Connection conn = this.getConnection();
        if (conn != null) {
            Statement statement = conn.createStatement();
            return statement.executeUpdate(sql);
        }
        return 0;
    }

    public boolean executeSQL(String sql) {
        try {
            this.execute(sql);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public void close() {
        if (!this.isClosed()) {
            try {
                this.connection().close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection(null);
        }
    }

    public void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            this.connection(this.newConnection());
        }
        return this.connection();
    }

    protected Connection newConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    protected boolean isClosed() {
        return this.connection() == null;
    }
}

