/*
 * Decompiled with CFR 0.152.
 */
package org.pf.directory;

import org.pf.directory.DistinguishedNameElement;
import org.pf.text.StringPattern;
import org.pf.text.StringUtil;
import org.pf.util.CollectionUtil;

public class DistinguishedName {
    public static final DistinguishedName EMPTY_DN = new DistinguishedName();
    protected static final String ELEMENT_SEPARATOR = ",";
    private static final StringPattern DN_ELEMENT_PATTERN = StringPattern.create("*?=*?", true);
    private String normalizedDN = null;
    private DistinguishedNameElement[] elements = null;

    protected String getNormalizedDN() {
        return this.normalizedDN;
    }

    protected void setNormalizedDN(String newValue) {
        this.normalizedDN = newValue;
    }

    protected DistinguishedNameElement[] getElements() {
        return this.elements;
    }

    protected void setElements(DistinguishedNameElement[] newValue) {
        this.elements = newValue;
    }

    public static boolean looksLikeDistinguishedName(String name) {
        return name != null && name.indexOf(61) > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDistinguishedName(String name) {
        try {
            DistinguishedName dn = new DistinguishedName(name);
            DistinguishedNameElement[] parts = dn.getElements();
            int i = 0;
            while (true) {
                if (i >= parts.length) {
                    return true;
                }
                if (!DN_ELEMENT_PATTERN.matches(parts[i].toString())) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    protected DistinguishedName() {
        this.setNormalizedDN("");
        this.setElements(new DistinguishedNameElement[0]);
    }

    public DistinguishedName(String dn) {
        if (this.str().isNullOrBlank(dn)) {
            throw new IllegalArgumentException("dn must not be null or empty");
        }
        this.init(dn);
    }

    protected DistinguishedName(DistinguishedNameElement[] parts) {
        if (this.coll().isNullOrEmpty(parts)) {
            throw new IllegalArgumentException("normalized parts must not be null or empty");
        }
        this.initFromNormalizedParts(parts);
    }

    public String toString() {
        return this.getNormalizedDN();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DistinguishedName) {
            DistinguishedName dn = (DistinguishedName)obj;
            return this.getNormalizedDN().equalsIgnoreCase(dn.getNormalizedDN());
        }
        return false;
    }

    public int hashCode() {
        return this.getNormalizedDN().toLowerCase().hashCode();
    }

    public boolean isEqual(String dn) {
        if (dn == null) {
            return false;
        }
        DistinguishedName distinguishedName = new DistinguishedName(dn);
        return this.equals(distinguishedName);
    }

    public boolean isEmptyDN() {
        return this.partCount() == 0 && this.getNormalizedDN().length() == 0;
    }

    public boolean isParentOf(DistinguishedName dn) {
        if (dn == null || dn.getElements() == null) {
            return false;
        }
        DistinguishedNameElement[] parts = this.getElements();
        if (parts.length < dn.getElements().length) {
            int j = dn.getElements().length - 1;
            int i = parts.length - 1;
            while (i >= 0) {
                if (!parts[i].equalsIgnoreCase(dn.getElements()[j])) {
                    return false;
                }
                --j;
                --i;
            }
            return true;
        }
        return false;
    }

    public boolean isDirectParentOf(DistinguishedName dn) {
        if (dn == null || dn.getElements() == null) {
            return false;
        }
        if (this.getElements().length == dn.getElements().length - 1) {
            return this.isParentOf(dn);
        }
        return false;
    }

    public DistinguishedNameElement[] getParts() {
        return (DistinguishedNameElement[])this.coll().copy(this.getElements());
    }

    public DistinguishedNameElement[] getPartsWithout(int skip) {
        DistinguishedNameElement[] parts = new DistinguishedNameElement[this.partCount() - skip];
        System.arraycopy(this.getElements(), 0, parts, 0, parts.length);
        return parts;
    }

    public DistinguishedNameElement getRDN() {
        if (this.partCount() > 0) {
            return this.getElements()[0];
        }
        return null;
    }

    public int partCount() {
        return this.getElements().length;
    }

    public DistinguishedName getParent() {
        if (this.partCount() <= 1) {
            return EMPTY_DN;
        }
        DistinguishedNameElement[] parts = new DistinguishedNameElement[this.getElements().length - 1];
        System.arraycopy(this.getElements(), 1, parts, 0, parts.length);
        return new DistinguishedName(parts);
    }

    public DistinguishedName makeChild(DistinguishedNameElement rdn) {
        DistinguishedNameElement[] parts = new DistinguishedNameElement[this.getElements().length + 1];
        System.arraycopy(this.getElements(), 0, parts, 1, this.getElements().length);
        parts[0] = rdn;
        return new DistinguishedName(parts);
    }

    protected void init(String dn) {
        String[] parts = this.str().parts(dn, ELEMENT_SEPARATOR);
        DistinguishedNameElement[] dnElements = new DistinguishedNameElement[parts.length];
        int i = 0;
        while (i < parts.length) {
            String[] keyValue = this.str().splitNameValue(parts[i].trim(), "=");
            dnElements[i] = new DistinguishedNameElement(keyValue[0].trim(), keyValue[1].trim());
            ++i;
        }
        this.initFromNormalizedParts(dnElements);
    }

    protected void initFromNormalizedParts(DistinguishedNameElement[] parts) {
        this.setNormalizedDN(this.asString(parts, ELEMENT_SEPARATOR));
        this.setElements(parts);
    }

    protected String asString(DistinguishedNameElement[] parts, String separator) {
        StringBuffer buffer = new StringBuffer(80);
        int i = 0;
        while (i < parts.length) {
            if (i > 0) {
                buffer.append(separator);
            }
            buffer.append(parts[i].toString());
            ++i;
        }
        return buffer.toString();
    }

    protected CollectionUtil coll() {
        return CollectionUtil.current();
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

