/*
 * Decompiled with CFR 0.152.
 */
package org.pf.directory;

import java.util.ArrayList;
import java.util.List;
import org.pf.text.StringUtil;
import org.pf.util.NamedValue;

public class MultiValueAttribute
extends NamedValue {
    private boolean mustBeEncoded = false;
    private boolean ignoreCase = false;

    public boolean mustBeEncoded() {
        return this.mustBeEncoded;
    }

    public void mustBeEncoded(boolean newValue) {
        this.mustBeEncoded = newValue;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean newValue) {
        this.ignoreCase = newValue;
    }

    public MultiValueAttribute(String attrName) {
        this(attrName, false);
    }

    public MultiValueAttribute(String attrName, boolean encoded) {
        super(attrName, new ArrayList());
        this.mustBeEncoded(encoded);
    }

    public String getName() {
        return this.name();
    }

    public List getValues() {
        return (List)this.value();
    }

    public String[] getValuesAsStrings() {
        return StringUtil.current().asStrings(this.getValues());
    }

    public Object getFirstValue() {
        return this.getValues().get(0);
    }

    public String getFirstValueAsString() {
        return this.getFirstValue().toString();
    }

    public void addValue(Object value) {
        if (!this.containsValue(value)) {
            this.getValues().add(value);
        }
    }

    public void addValues(Object[] values) {
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                this.addValue(values[i]);
                ++i;
            }
        }
    }

    public void addValues(List values) {
        if (values != null) {
            int i = 0;
            while (i < values.size()) {
                this.addValue(values.get(i));
                ++i;
            }
        }
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        List currentValues = this.getValues();
        if (value instanceof String && this.getIgnoreCase()) {
            String str = (String)value;
            int max = this.valueCount();
            int i = 0;
            while (i < max) {
                Object object = currentValues.get(i);
                if (object instanceof String && str.equalsIgnoreCase((String)object)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return currentValues.contains(value);
    }

    public void setSoleValue(Object value) {
        this.getValues().clear();
        this.getValues().add(value);
    }

    public MultiValueAttribute copy() {
        MultiValueAttribute copy = new MultiValueAttribute(this.name(), this.mustBeEncoded());
        copy.setValue(this.getValue());
        return copy;
    }

    public int valueCount() {
        return this.getValues().size();
    }

    public boolean isEmpty() {
        return this.valueCount() == 0;
    }
}

