/*
 * Decompiled with CFR 0.152.
 */
package org.pf.directory;

import java.util.ArrayList;
import java.util.List;
import org.pf.directory.MultiValueAttribute;
import org.pf.directory.ldap.LDAPUtil;
import org.pf.directory.metadata.AttributeMetaData;
import org.pf.directory.metadata.AttributesMetaData;
import org.pf.reflect.AttributeReadAccess;
import org.pf.text.StringUtil;
import org.pf.util.NamedValueList;

public class MultiValueAttributes
implements AttributeReadAccess {
    private NamedValueList keyedAttributes = null;
    private AttributesMetaData metaData = null;

    protected NamedValueList getKeyedAttributes() {
        return this.keyedAttributes;
    }

    protected void setKeyedAttributes(NamedValueList newValue) {
        this.keyedAttributes = newValue;
    }

    public AttributesMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(AttributesMetaData newValue) {
        this.metaData = newValue;
    }

    public MultiValueAttributes() {
        this.reset();
    }

    public Object getValue(String attrName) {
        MultiValueAttribute attr = this.getAttribute(attrName);
        if (attr == null) {
            return null;
        }
        return attr.getFirstValue();
    }

    public List getValues(String attrName) {
        return this.basicGetValues(attrName);
    }

    public void addValue(String attrName, Object value) {
        this.putValue(attrName, value, false);
    }

    public void addValue(String attrName, Object value, boolean encoded) {
        this.putValue(attrName, value, encoded);
    }

    public void addAttribute(MultiValueAttribute attribute) {
        if (attribute != null) {
            if (this.hasAttribute(attribute.getName())) {
                this.removeAttribute(attribute.getName());
            }
            this.basicAddAttribute(attribute);
        }
    }

    public void removeAttribute(String attrName) {
        this.basicRemoveAttribute(attrName);
    }

    public void removeValue(String attrName, Object value) {
        if (attrName == null) {
            return;
        }
        if (value == null) {
            return;
        }
        List values = this.basicGetValues(attrName);
        if (values != null) {
            values.remove(value);
            if (values.isEmpty()) {
                this.removeAttribute(attrName);
            }
        }
    }

    public String[] getAttributeNames() {
        return this.str().asStrings(this.getAttributeNameList());
    }

    public Object getAttributeValue(String attrName) throws NoSuchFieldException {
        if (this.hasAttribute(attrName)) {
            return this.basicGetValues(attrName);
        }
        throw new NoSuchFieldException("Attribute '" + attrName + "' not found");
    }

    public MultiValueAttribute getAttribute(String attrName) {
        return this.basicGetAttribute(attrName);
    }

    public boolean hasAttribute(String attrName) {
        return this.basicGetAttribute(attrName) != null;
    }

    public int size() {
        return this.getKeyedAttributes().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public MultiValueAttributes getCopyOfAttributes(String[] attrNames) {
        boolean copyAll = this.str().isNullOrEmpty(attrNames) || this.str().contains(attrNames, "*");
        MultiValueAttributes copy = this.newInstance();
        String[] allAttrNames = this.getAttributeNames();
        int i = 0;
        while (i < allAttrNames.length) {
            if (copyAll || this.str().containsIgnoreCase(attrNames, allAttrNames[i])) {
                MultiValueAttribute attr = this.getAttribute(allAttrNames[i]);
                copy.addAttribute(attr.copy());
            }
            ++i;
        }
        return copy;
    }

    public String getAttributeAsString(String attrName) throws NoSuchFieldException {
        MultiValueAttribute attr = this.getAttribute(attrName);
        if (attr == null) {
            throw new NoSuchFieldException(attrName);
        }
        if (attr.isEmpty()) {
            return null;
        }
        return attr.getFirstValue().toString();
    }

    public String[] getAttributeAsStringArray(String attrName) throws NoSuchFieldException {
        MultiValueAttribute attr = this.getAttribute(attrName);
        if (attr == null) {
            throw new NoSuchFieldException(attrName);
        }
        if (attr.isEmpty()) {
            return StringUtil.EMPTY_STRING_ARRAY;
        }
        return attr.getValuesAsStrings();
    }

    protected MultiValueAttributes newInstance() {
        return new MultiValueAttributes();
    }

    protected void putValue(String name, Object value, boolean encoded) {
        if (name == null) {
            return;
        }
        if (value == null) {
            return;
        }
        Object valueToStore = this.lutil().asEncryptedStringIfApplicable(value);
        MultiValueAttribute attr = this.basicGetAttribute(name);
        if (attr == null) {
            this.createAttribute(name, valueToStore, encoded);
        } else if (this.isSingleValueAttribute(attr.getName())) {
            attr.setSoleValue(valueToStore);
        } else {
            attr.addValue(valueToStore);
        }
    }

    protected List basicGetValues(String name) {
        MultiValueAttribute attr = this.basicGetAttribute(name);
        if (attr == null) {
            return null;
        }
        return attr.getValues();
    }

    protected MultiValueAttribute createAttribute(String name, Object value, boolean encoded) {
        MultiValueAttribute attr = new MultiValueAttribute(name, encoded);
        attr.addValue(value);
        this.basicAddAttribute(attr);
        return attr;
    }

    protected MultiValueAttribute basicGetAttribute(String name) {
        String normalizedName = this.normalizeName(name);
        return (MultiValueAttribute)this.getKeyedAttributes().valueAt(normalizedName);
    }

    protected void basicAddAttribute(MultiValueAttribute attr) {
        String normalizedName = this.normalizeName(attr.name());
        this.getKeyedAttributes().add(normalizedName, (Object)attr);
    }

    protected void basicRemoveAttribute(String name) {
        String normalizedName = this.normalizeName(name);
        this.getKeyedAttributes().remove(normalizedName);
    }

    protected List getAttributeNameList() {
        ArrayList nameList = new ArrayList(this.getKeyedAttributes().size());
        this.appendAttributeNames(nameList);
        return nameList;
    }

    protected void appendAttributeNames(List nameList) {
        List nameValuePairs = this.getKeyedAttributes().values();
        int i = 0;
        while (i < nameValuePairs.size()) {
            MultiValueAttribute attr = (MultiValueAttribute)nameValuePairs.get(i);
            nameList.add(attr.name());
            ++i;
        }
    }

    protected boolean isSingleValueAttribute(String attrName) {
        AttributeMetaData attrMetaData;
        if (this.getMetaData() != null && (attrMetaData = this.getMetaData().getMetaData(attrName)) != null) {
            return attrMetaData.isSingleValued();
        }
        return false;
    }

    protected String normalizeName(String name) {
        return name.toLowerCase();
    }

    protected void reset() {
        this.setKeyedAttributes(new NamedValueList());
    }

    protected List newValueList() {
        return new ArrayList();
    }

    protected LDAPUtil lutil() {
        return LDAPUtil.current();
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

