/*
 * Decompiled with CFR 0.152.
 */
package org.pf.directory.ldap;

import java.util.Iterator;
import org.pf.bif.filter.IObjectFilter;
import org.pf.directory.DirectoryObject;
import org.pf.directory.DistinguishedName;
import org.pf.directory.MultiValueAttribute;
import org.pf.directory.MultiValueAttributes;
import org.pf.directory.ldap.LDAPSearchResult;
import org.pf.directory.ldap.LDAPUtil;

public class LDAPDirEntry
extends DirectoryObject {
    public static final String ATTRNAME_CREATE_TIMESTAMP = "createtimestamp";
    public static final String ATTRNAME_MODIFY_TIMESTAMP = "modifytimestamp";
    public static final String ATTRNAME_CREATORS_NAME = "creatorsname";
    public static final String ATTRNAME_MODIFIERS_NAME = "modifiersname";
    public static final String ATTRNAME_SUBSCHEMA_SUBENTRY = "subschemasubentry";
    public static final String ATTRNAME_NAMING_CONTEXTS = "namingcontexts";
    private DistinguishedName distinguishedName = null;

    public DistinguishedName getDistinguishedName() {
        return this.distinguishedName;
    }

    protected void setDistinguishedName(DistinguishedName newValue) {
        this.distinguishedName = newValue;
    }

    public LDAPDirEntry(String dn) {
        this(dn != null && dn.length() == 0 ? DistinguishedName.EMPTY_DN : new DistinguishedName(dn));
    }

    public LDAPDirEntry(DistinguishedName dn) {
        super(dn.toString());
        this.setDistinguishedName(dn);
    }

    public LDAPDirEntry(LDAPDirEntry dirObject) {
        this(dirObject.getDN());
        this.setMetaData(dirObject.getMetaData());
        this.copyAttributesFrom(dirObject);
    }

    public String getCreateTimestamp() {
        try {
            return this.getAttributeAsString(ATTRNAME_CREATE_TIMESTAMP);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public String getModifyTimestamp() {
        try {
            return this.getAttributeAsString(ATTRNAME_MODIFY_TIMESTAMP);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public void setCreateTimestamp(String timestamp) {
        this.setAttribute(ATTRNAME_CREATE_TIMESTAMP, timestamp);
    }

    public void setModifyTimestamp(String timestamp) {
        this.setAttribute(ATTRNAME_MODIFY_TIMESTAMP, timestamp);
    }

    public void updateTimestamps() {
        String timestamp = LDAPUtil.current().createTimestamp();
        this.setCreateTimestamp(timestamp);
        this.setModifyTimestamp(timestamp);
    }

    public void updateModifyTimestamp() {
        String timestamp = LDAPUtil.current().createTimestamp();
        this.setModifyTimestamp(timestamp);
    }

    public void setAttribute(String attrName, String attrValue) {
        if (this.str().isNullOrEmpty(attrName) || this.str().isNullOrEmpty(attrValue)) {
            return;
        }
        MultiValueAttribute attribute = this.getAttribute(attrName);
        if (attribute == null) {
            attribute = new MultiValueAttribute(attrName);
            this.addAttribute(attribute);
        }
        attribute.setSoleValue(attrValue);
    }

    public String getDN() {
        return this.getIdentifier();
    }

    public boolean isContainer() {
        return false;
    }

    public void updateFrom(MultiValueAttributes attributes) {
        String[] attrNames = attributes.getAttributeNames();
        int i = 0;
        while (i < attrNames.length) {
            MultiValueAttribute attr = attributes.getAttribute(attrNames[i]);
            Iterator values = attr.getValues().iterator();
            while (values.hasNext()) {
                this.addValue(attrNames[i], values.next(), attr.mustBeEncoded());
            }
            ++i;
        }
    }

    public String toString() {
        return "LDAPDirEntry(" + this.getDN() + ")";
    }

    protected void copyAttributesFrom(LDAPDirEntry dirObject) {
        String[] names = dirObject.getAttributeNames();
        int i = 0;
        while (i < names.length) {
            MultiValueAttribute attr = dirObject.getAttribute(names[i]);
            this.basicAddAttribute(attr);
            ++i;
        }
    }

    protected void collectAll(LDAPSearchResult result, IObjectFilter filter) {
        if (filter.matches(this)) {
            result.add(this);
        }
    }

    protected String inspectString() {
        return "LDAPDirEntry(" + this.getDN() + ")";
    }
}

