/*
 * Decompiled with CFR 0.152.
 */
package org.pf.directory.ldap;

import org.pf.bif.filter.IObjectFilter;
import org.pf.directory.DistinguishedName;
import org.pf.directory.ldap.LDAPDirEntry;
import org.pf.directory.ldap.LDAPDirEntryFilter;
import org.pf.directory.ldap.LDAPSearchResult;
import org.pf.osf.MatchRuleFilter;
import org.pf.osf.ObjectContainer;
import org.pf.osf.ObjectSearchResult;
import org.pf.text.LdapFilterParser;
import org.pf.text.MatchRule;
import org.pf.text.MatchRuleParseException;

public class LDAPDirEntryContainer
extends LDAPDirEntry {
    private ObjectContainer children = new ObjectContainer(20);

    protected ObjectContainer getChildren() {
        return this.children;
    }

    protected void setChildren(ObjectContainer newValue) {
        this.children = newValue;
    }

    public LDAPDirEntryContainer(String dn) {
        super(dn);
    }

    public LDAPDirEntryContainer(DistinguishedName dn) {
        super(dn);
    }

    public LDAPDirEntryContainer(LDAPDirEntry dirObject) {
        super(dirObject);
    }

    public void addChild(LDAPDirEntry entry) {
        if (entry != null) {
            this.getChildren().add(entry);
        }
    }

    public boolean removeChild(LDAPDirEntry entry) {
        if (entry != null) {
            return this.getChildren().remove(entry);
        }
        return false;
    }

    public boolean removeChild(DistinguishedName dn) {
        if (dn != null) {
            LDAPDirEntry entry = new LDAPDirEntry(dn);
            return this.getChildren().removeEqual(entry);
        }
        return false;
    }

    public boolean contains(LDAPDirEntry entry) {
        if (entry == null) {
            return false;
        }
        return this.getChildren().contains(entry);
    }

    public boolean contains(DistinguishedName dn) {
        if (dn == null) {
            return false;
        }
        LDAPDirEntry entry = new LDAPDirEntry(dn);
        return this.getChildren().containsEqualObject(entry);
    }

    public LDAPDirEntry findChild(LDAPDirEntryFilter filter) {
        return (LDAPDirEntry)this.getChildren().findFirst(filter);
    }

    public LDAPDirEntry findChild(String filter) throws MatchRuleParseException {
        MatchRule rule = this.filterToRule(filter);
        return (LDAPDirEntry)this.getChildren().findFirst(rule);
    }

    public LDAPSearchResult findChildren(String filter) throws MatchRuleParseException {
        return this.findChildren(filter, 0);
    }

    public LDAPSearchResult findChildren(LDAPDirEntryFilter filter) {
        return this.findChildren(filter, 0);
    }

    public LDAPSearchResult findChildren(String filter, int sizeLimit) throws MatchRuleParseException {
        MatchRule rule = this.filterToRule(filter);
        LDAPSearchResult result = new LDAPSearchResult(this.getChildren().size(), sizeLimit);
        this.getChildren().find((ObjectSearchResult)result, rule);
        return result;
    }

    public LDAPSearchResult findChildren(LDAPDirEntryFilter filter, int sizeLimit) {
        LDAPSearchResult result = new LDAPSearchResult(this.getChildren().size(), sizeLimit);
        this.getChildren().find((ObjectSearchResult)result, filter);
        return result;
    }

    public LDAPSearchResult findAll(String filter) throws MatchRuleParseException {
        return this.findAll(filter, 0);
    }

    public LDAPSearchResult findAll(LDAPDirEntryFilter filter) {
        return this.findAll(filter, 0);
    }

    public LDAPSearchResult findAll(String filter, int sizeLimit) throws MatchRuleParseException {
        MatchRule rule = this.filterToRule(filter);
        LDAPSearchResult result = new LDAPSearchResult(this.getChildCount() + 100, sizeLimit);
        this.collectAll(result, new MatchRuleFilter(rule));
        return result;
    }

    public LDAPSearchResult findAll(LDAPDirEntryFilter filter, int sizeLimit) {
        LDAPSearchResult result = new LDAPSearchResult(this.getChildCount() + 100, sizeLimit);
        this.collectAll(result, filter);
        return result;
    }

    public boolean isContainer() {
        return true;
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    public String toString() {
        return "LDAPDirEntryContainer(" + this.getDN() + ")";
    }

    protected MatchRule filterToRule(String ldapFilter) throws MatchRuleParseException {
        MatchRule rule = LdapFilterParser.parseFilter(ldapFilter);
        rule.ignoreCase(true);
        rule.ignoreCaseInNames(true);
        return rule;
    }

    protected void collectAll(LDAPSearchResult result, IObjectFilter filter) {
        if (filter.matches(this)) {
            result.add(this);
        }
        int i = 0;
        while (i < this.getChildren().size() && !result.isSizeLimitExceeded()) {
            LDAPDirEntry child = (LDAPDirEntry)this.getChildren().get(i);
            child.collectAll(result, filter);
            ++i;
        }
    }
}

