/*
 * Decompiled with CFR 0.152.
 */
package org.pf.directory.ldap;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.pf.text.StringPattern;
import org.pf.text.StringUtil;
import org.pf.util.Base64Converter;

public class LDAPUtil {
    public static final String DISTINGUISHED_NAME = "dn";
    public static final StringPattern ENCRYPTION_PATTERN = new StringPattern("{*}*");
    protected static final String ATTRIBUTE_ASSIGNMENT = "=";
    protected static final String DN_ELEMENT_SEPARATOR = ",";
    protected static final SimpleDateFormat LDAP_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static LDAPUtil soleInstance = new LDAPUtil();

    public static LDAPUtil current() {
        return soleInstance;
    }

    protected LDAPUtil() {
    }

    public String normalizeDN(String dn) {
        String[] parts = this.str().parts(dn, DN_ELEMENT_SEPARATOR);
        int i = 0;
        while (i < parts.length) {
            String[] keyValue = this.str().splitNameValue(parts[i], ATTRIBUTE_ASSIGNMENT);
            parts[i] = String.valueOf(keyValue[0].trim()) + ATTRIBUTE_ASSIGNMENT + keyValue[1].trim();
            ++i;
        }
        return this.str().asString(parts, DN_ELEMENT_SEPARATOR);
    }

    public boolean needsEncoding(Object value) {
        if (value instanceof byte[]) {
            return true;
        }
        if (value instanceof String) {
            String str = (String)value;
            return ENCRYPTION_PATTERN.matches(str);
        }
        return false;
    }

    public Object asEncryptedStringIfApplicable(Object value) {
        String str;
        if (value instanceof byte[] && ENCRYPTION_PATTERN.matches(str = new String((byte[])value))) {
            return str;
        }
        return value;
    }

    public String encodeToBase64(Object obj) {
        if (obj instanceof byte[]) {
            byte[] bytes = (byte[])obj;
            return Base64Converter.encodeToString(bytes);
        }
        return Base64Converter.encode(obj.toString());
    }

    public String createTimestamp(Date date) {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append(LDAP_TIMESTAMP_FORMAT.format(date));
        buffer.append('Z');
        return buffer.toString();
    }

    public String createTimestamp() {
        return this.createTimestamp(new Date());
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

