/*
 * Decompiled with CFR 0.152.
 */
package org.pf.directory.ldif;

import org.pf.directory.ldap.LDAPUtil;
import org.pf.file.LineProcessor;
import org.pf.text.StringPattern;
import org.pf.text.StringUtil;
import org.pf.util.NamedText;

public abstract class LDIFLineProcessor
implements LineProcessor {
    protected static final String OBJECT_ID_ATTR = "dn";
    protected static final String LDIF_VERSION_ATTR = "version";
    protected static final String KEY_VALUE_SEPARATOR = ":";
    protected static final String BASE64_INDICATOR = ":";
    protected static final String COMMENT_INDICATOR = "#";
    protected static final String CONTINUATION_INDICATOR = " ";
    protected static final String OBJECT_START_INDICATOR = "dn:";
    protected static final int LINE_TYPE_UNKNOWN = 0;
    protected static final int LINE_TYPE_EMPTY = 1;
    protected static final int LINE_TYPE_COMMENT = 2;
    protected static final int LINE_TYPE_OBJECT = 3;
    protected static final int LINE_TYPE_ATTRIBUTE = 4;
    protected static final int LINE_TYPE_CONTINUED = 5;
    private StringPattern attributePattern = null;
    private StringBuffer lineBuffer = null;
    private boolean bufferUnused = true;

    protected StringPattern getAttributePattern() {
        return this.attributePattern;
    }

    protected void setAttributePattern(StringPattern newValue) {
        this.attributePattern = newValue;
    }

    protected StringBuffer getLineBuffer() {
        return this.lineBuffer;
    }

    protected void setLineBuffer(StringBuffer newValue) {
        this.lineBuffer = newValue;
    }

    protected boolean isBufferUnused() {
        return this.bufferUnused;
    }

    protected void setBufferUnused(boolean newValue) {
        this.bufferUnused = newValue;
    }

    protected LDIFLineProcessor() {
        this.setAttributePattern(new StringPattern("*:*"));
        this.resetBuffer();
    }

    public boolean processLine(String line, int lineNo) {
        if (this.isBufferUnused()) {
            this.addToBuffer(line.trim());
        } else {
            int lineType = this.detectLineType(line);
            if (lineType == 5) {
                this.addToBuffer(line.substring(1));
            } else {
                String dataLine = this.getLineBuffer().toString();
                this.resetBuffer();
                this.addToBuffer(line.trim());
                lineType = this.detectLineType(dataLine);
                switch (lineType) {
                    case 4: {
                        return this.processAttribute(dataLine);
                    }
                    case 2: {
                        return this.processComment(dataLine);
                    }
                    case 3: {
                        return this.processNewObject(dataLine);
                    }
                    case 1: {
                        return this.processEmptyLine();
                    }
                }
            }
        }
        return true;
    }

    protected abstract boolean handleNewObject(NamedText var1);

    protected abstract boolean handleAttribute(NamedText var1, boolean var2);

    protected abstract boolean handleComment(String var1);

    protected abstract boolean handleEmptyLine();

    protected boolean processNewObject(String line) {
        NamedText keyValue = this.parseKeyValue(line);
        if (keyValue != null) {
            keyValue.text(this.ldap().normalizeDN(keyValue.text()));
            return this.handleNewObject(keyValue);
        }
        return true;
    }

    protected boolean processAttribute(String line) {
        NamedText keyValue = this.parseKeyValue(line);
        if (keyValue != null) {
            boolean encoded = keyValue.text().startsWith(":");
            if (encoded) {
                keyValue.text(keyValue.text().substring(1).trim());
            }
            return this.handleAttribute(keyValue, encoded);
        }
        return true;
    }

    protected boolean processComment(String line) {
        return this.handleComment(line.substring(1));
    }

    protected boolean processEmptyLine() {
        return this.handleEmptyLine();
    }

    protected int detectLineType(String line) {
        if (line.trim().length() == 0) {
            return 1;
        }
        if (line.startsWith(COMMENT_INDICATOR)) {
            return 2;
        }
        if (line.startsWith(OBJECT_START_INDICATOR)) {
            return 3;
        }
        if (line.startsWith(CONTINUATION_INDICATOR)) {
            return 5;
        }
        if (this.getAttributePattern().matches(line)) {
            return 4;
        }
        return 0;
    }

    protected NamedText parseKeyValue(String line) {
        String[] parts = this.str().splitNameValue(line, ":");
        NamedText keyValue = new NamedText(parts[0].trim(), parts[1].trim());
        return keyValue;
    }

    protected void addToBuffer(String line) {
        this.getLineBuffer().append(line);
        this.setBufferUnused(false);
    }

    protected void resetBuffer() {
        this.setLineBuffer(new StringBuffer(100));
        this.setBufferUnused(true);
    }

    protected LDAPUtil ldap() {
        return LDAPUtil.current();
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

