/*
 * Decompiled with CFR 0.152.
 */
package org.pf.directory.ldif;

import java.io.IOException;
import java.io.InputStream;
import org.pf.directory.ldap.LDAPDirEntry;
import org.pf.directory.ldif.LDIFLineProcessor;
import org.pf.file.FileUtil;
import org.pf.file.LineProcessor;
import org.pf.osf.ObjectContainer;
import org.pf.util.Base64Converter;
import org.pf.util.NamedText;

public class LDIFReader
extends LDIFLineProcessor {
    private ObjectContainer allObjects = null;
    private LDAPDirEntry currentObject = null;

    protected ObjectContainer getAllObjects() {
        return this.allObjects;
    }

    protected void setAllObjects(ObjectContainer newValue) {
        this.allObjects = newValue;
    }

    protected LDAPDirEntry getCurrentObject() {
        return this.currentObject;
    }

    protected void setCurrentObject(LDAPDirEntry newValue) {
        this.currentObject = newValue;
    }

    public static LDIFReader n() {
        return new LDIFReader();
    }

    public ObjectContainer read(String filename) throws IOException {
        this.reset();
        this.futil().processTextLines(filename, (LineProcessor)this);
        return this.getAllObjects();
    }

    public ObjectContainer read(InputStream stream) throws IOException {
        this.reset();
        this.futil().processTextLines(stream, (LineProcessor)this);
        return this.getAllObjects();
    }

    protected boolean handleAttribute(NamedText keyValuePair, boolean encoded) {
        if (this.getCurrentObject() != null) {
            Object value = encoded ? (Object)Base64Converter.decode(keyValuePair.text()) : keyValuePair.text();
            this.getCurrentObject().addValue(keyValuePair.name(), value);
        }
        return true;
    }

    protected boolean handleComment(String line) {
        return true;
    }

    protected boolean handleEmptyLine() {
        return true;
    }

    protected boolean handleNewObject(NamedText objectId) {
        LDAPDirEntry entry = this.newEntry(objectId.text());
        this.setCurrentObject(entry);
        this.getAllObjects().add(entry);
        return true;
    }

    protected LDAPDirEntry newEntry(String dn) {
        return new LDAPDirEntry(dn);
    }

    protected void reset() {
        this.setAllObjects(this.newObjectContainer());
    }

    protected ObjectContainer newObjectContainer() {
        return this.newObjectContainer(100);
    }

    protected ObjectContainer newObjectContainer(int initialSize) {
        return new ObjectContainer(initialSize);
    }

    protected FileUtil futil() {
        return FileUtil.current();
    }
}

