/*
 * Decompiled with CFR 0.152.
 */
package org.pf.directory.ldif;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.pf.directory.MultiValueAttribute;
import org.pf.directory.ldap.LDAPDirEntry;
import org.pf.directory.ldap.LDAPUtil;

public class LDIFWriter {
    protected static final String COLON = ":";

    public static LDIFWriter n() {
        return new LDIFWriter();
    }

    protected void appendVersion(PrintStream stream) {
        stream.println("Version: 1");
        stream.println();
    }

    protected void appendObject(PrintStream stream, LDAPDirEntry entry) {
        stream.print("dn:");
        stream.println(entry.getDN());
        String[] attrNames = entry.getAttributeNames();
        int i = 0;
        while (i < attrNames.length) {
            MultiValueAttribute attribute = entry.getAttribute(attrNames[i]);
            List values = attribute.getValues();
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                stream.print(attribute.getName());
                stream.print(COLON);
                Object value = iter.next();
                if (this.lutil().needsEncoding(value)) {
                    stream.print(COLON);
                    value = this.lutil().encodeToBase64(value);
                }
                stream.println(value.toString());
            }
            ++i;
        }
        stream.println();
    }

    protected LDAPUtil lutil() {
        return LDAPUtil.current();
    }
}

