/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.pf.file.ClasspathElement;
import org.pf.file.FileFinder;
import org.pf.file.FileUtil;
import org.pf.text.StringPattern;
import org.pf.text.StringUtil;

public class Classpath {
    protected static final String DEFAULT_SEPARATOR = File.pathSeparator;
    private List elements = null;

    protected List getElements() {
        return this.elements;
    }

    protected void setElements(List newValue) {
        this.elements = newValue;
    }

    public Classpath() {
        this((String)null);
    }

    public Classpath(String classpath) {
        this(classpath, DEFAULT_SEPARATOR);
    }

    public Classpath(String classpath, String separator) {
        if (classpath == null) {
            classpath = this.fileUtil().getClasspath();
        }
        this.init(classpath, separator == null ? DEFAULT_SEPARATOR : separator);
    }

    public Classpath(String[] classpathElements) {
        this.initFromParts(classpathElements);
    }

    public Classpath(Collection classpathElements) {
        this.initFromParts(this.str().asStrings(classpathElements));
    }

    public ClasspathElement[] allElements() {
        return this.elementArray(this.getElements());
    }

    public ClasspathElement[] validElements() {
        return this.collectElements(true);
    }

    public ClasspathElement[] invalidElements() {
        return this.collectElements(false);
    }

    public ClasspathElement[] elementsContaining(String filename) {
        return this.elementsWithFile(filename);
    }

    public ClasspathElement firstElementContaining(String filename) {
        ClasspathElement[] cpElements = this.elementsWithFile(filename, true);
        if (cpElements == null || cpElements.length == 0) {
            return null;
        }
        return cpElements[0];
    }

    public void removeDuplicates() {
        ArrayList newList = new ArrayList(this.getElements().size());
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (newList.contains(element)) continue;
            newList.add(element);
        }
        this.setElements(newList);
    }

    public String toString() {
        return this.toString(DEFAULT_SEPARATOR);
    }

    public String toString(String separator) {
        StringBuffer buffer = new StringBuffer(this.getElements().size() * 20);
        int i = 0;
        while (i < this.getElements().size()) {
            ClasspathElement element = (ClasspathElement)this.getElements().get(i);
            if (i > 0) {
                buffer.append(separator);
            }
            buffer.append(element.getName());
            ++i;
        }
        return buffer.toString();
    }

    protected void init(String classpath, String separator) {
        if (classpath == null) {
            this.setElements(new ArrayList());
            return;
        }
        String[] parts = this.str().parts(classpath, separator);
        this.initFromParts(parts);
    }

    protected void initFromParts(String[] parts) {
        if (this.str().isNullOrEmpty(parts)) {
            this.setElements(new ArrayList());
            return;
        }
        this.setElements(new ArrayList(parts.length));
        int i = 0;
        while (i < parts.length) {
            String elementName = parts[i].trim();
            this.appendElement(elementName);
            ++i;
        }
    }

    protected void appendElement(String elementName) {
        if (StringPattern.containsWildcard(elementName)) {
            File[] files = FileFinder.findFiles(elementName);
            int i = 0;
            while (i < files.length) {
                this.basicAppendElement(files[i].getPath());
                ++i;
            }
        } else {
            this.basicAppendElement(elementName);
        }
    }

    protected void basicAppendElement(String elementName) {
        this.getElements().add(new ClasspathElement(elementName));
    }

    protected ClasspathElement[] elementsWithFile(String filename) {
        return this.elementsWithFile(filename, false);
    }

    protected ClasspathElement[] elementsWithFile(String filename, boolean onlyFirst) {
        ArrayList<ClasspathElement> collection = new ArrayList<ClasspathElement>(this.getElements().size());
        int i = 0;
        while (i < this.getElements().size()) {
            ClasspathElement element = (ClasspathElement)this.getElements().get(i);
            if (element.contains(filename)) {
                collection.add(element);
                if (onlyFirst) break;
            }
            ++i;
        }
        return this.elementArray(collection);
    }

    protected ClasspathElement[] collectElements(boolean valid) {
        ArrayList<ClasspathElement> collection = new ArrayList<ClasspathElement>(this.getElements().size());
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            ClasspathElement element = (ClasspathElement)iter.next();
            if (valid) {
                if (!element.isValid()) continue;
                collection.add(element);
                continue;
            }
            if (element.isValid()) continue;
            collection.add(element);
        }
        return this.elementArray(collection);
    }

    protected ClasspathElement[] elementArray(List elementList) {
        ClasspathElement[] array = new ClasspathElement[elementList.size()];
        return elementList.toArray(array);
    }

    protected FileUtil fileUtil() {
        return FileUtil.current();
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

