/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.pf.file.FileUtil;
import org.pf.file.LoggerProvider;
import org.pf.logging.Logger;
import org.pf.util.SysUtil;

public class ClasspathElement {
    private static final String FILE_PROTOCOL_INDICATOR = "file:/";
    private static final String JAR_FILE_PROTOCOL_INDICATOR = "jar:file:/";
    private static final String ARCHIVE_INDICATOR = "!/";
    private static final boolean DEBUG = "true".equals(System.getProperty("org.pf.file.ClasspathElement.debug"));
    private static final String DEBUG_PREFIX = "org.pf.file.ClasspathElement: ";
    private String name = null;
    private File file = null;
    private boolean valid = false;
    private String id = null;
    private boolean leaveArchiveOpen = false;
    private ZipFile zipFile = null;

    public String getName() {
        return this.name;
    }

    protected void setName(String newValue) {
        this.name = newValue;
    }

    protected File getFile() {
        return this.file;
    }

    protected void setFile(File newValue) {
        this.file = newValue;
    }

    protected boolean getValid() {
        return this.valid;
    }

    protected void setValid(boolean newValue) {
        this.valid = newValue;
    }

    protected String getId() {
        return this.id;
    }

    protected void setId(String newValue) {
        this.id = newValue;
    }

    public boolean leaveArchiveOpen() {
        return this.leaveArchiveOpen;
    }

    public void leaveArchiveOpen(boolean newValue) {
        this.leaveArchiveOpen = newValue;
    }

    protected void setZipFile(ZipFile newValue) {
        this.zipFile = newValue;
    }

    public ClasspathElement(File aFile) {
        if (aFile == null) {
            throw new IllegalArgumentException("ClasspathElement: File parameter must not be null");
        }
        this.init(aFile);
    }

    public ClasspathElement(String elementName) {
        if (elementName == null) {
            throw new IllegalArgumentException("ClasspathElement: elementName parameter must not be null");
        }
        this.init(new File(elementName));
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public boolean isFile() {
        return this.getFile().isFile();
    }

    public boolean isArchive() {
        return this.isFile() && this.isValid();
    }

    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    public boolean isValid() {
        return this.getValid();
    }

    public boolean isOpen() {
        return this.zipFile != null;
    }

    public boolean contains(String filename) {
        if (this.isValid()) {
            if (this.isDirectory()) {
                return this.dirContainsFile(filename);
            }
            return this.archiveContainsFile(filename);
        }
        return false;
    }

    public InputStream open(String filename) throws IOException {
        InputStream stream = null;
        if (this.isValid()) {
            if (this.isArchive()) {
                ZipFile aZipFile = this.getZipFile();
                ZipEntry zipEntry = aZipFile.getEntry(filename);
                if (zipEntry != null) {
                    stream = aZipFile.getInputStream(zipEntry);
                }
            } else {
                File aFile = new File(this.getFile(), filename);
                stream = new FileInputStream(aFile);
            }
        } else {
            throw new IOException("Invalid classpath element can't contain '" + filename + "'");
        }
        return stream;
    }

    public synchronized void close() {
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setZipFile(null);
        }
    }

    public URL getURL() {
        return this.createURL(null);
    }

    public URL createURL(String filename) {
        URL url;
        if (!this.isValid()) {
            return null;
        }
        StringBuffer urlStr = new StringBuffer(200);
        if (this.isArchive() && filename != null) {
            urlStr.append(JAR_FILE_PROTOCOL_INDICATOR);
        } else {
            urlStr.append(FILE_PROTOCOL_INDICATOR);
        }
        urlStr.append(this.futil().standardize(this.getFile().getAbsolutePath()));
        if (filename != null) {
            urlStr.append(this.isArchive() ? ARCHIVE_INDICATOR : "/");
            urlStr.append(filename);
        }
        try {
            url = new URL(urlStr.toString());
        }
        catch (MalformedURLException e) {
            if (DEBUG) {
                this.logger().logException(e);
            }
            return null;
        }
        return url;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ClasspathElement) {
            ClasspathElement otherElement = (ClasspathElement)object;
            return this.getId().equals(otherElement.getId());
        }
        return false;
    }

    protected void init(File aFile) {
        this.setFile(aFile);
        this.setName(this.futil().javaFilename(aFile.getPath()));
        this.setId(this.futil().standardize(aFile.getAbsolutePath()));
        if (this.sys().isWindows()) {
            this.setId(this.getId().toLowerCase());
        }
        if (this.exists()) {
            if (this.isDirectory()) {
                this.setValid(true);
            } else if (this.isFile()) {
                this.setValid(this.checkArchive());
            }
        }
    }

    protected boolean checkArchive() {
        try {
            this.getZipFile();
            if (!this.leaveArchiveOpen()) {
                this.close();
            }
            return true;
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected boolean dirContainsFile(String filename) {
        File aFile = new File(this.getFile(), filename);
        return aFile.exists();
    }

    /*
     * Exception decompiling
     */
    protected boolean archiveContainsFile(String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 63->66)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected synchronized ZipFile getZipFile() throws ZipException, IOException {
        if (this.zipFile == null) {
            this.zipFile = new ZipFile(this.getFile());
        }
        return this.zipFile;
    }

    protected void debug(String text) {
        this.logger().logDebug(DEBUG_PREFIX + text);
    }

    protected Logger logger() {
        return LoggerProvider.getLogger();
    }

    protected FileUtil futil() {
        return FileUtil.current();
    }

    protected SysUtil sys() {
        return SysUtil.current();
    }
}

