/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.pf.file.Classpath;
import org.pf.file.ClasspathElement;
import org.pf.file.ExtendedFileFilter;
import org.pf.file.FileHandler;
import org.pf.file.FileLocator;
import org.pf.file.FileUtil;
import org.pf.file.FileWalker;
import org.pf.file.LoggerProvider;
import org.pf.logging.Logger;
import org.pf.text.StringUtil;

public class FileFinder
implements FileHandler {
    private static final boolean DEBUG = "true".equals(System.getProperty("org.pf.file.FileFinder.debug"));
    private static final String DEBUG_PREFIX = "org.pf.file.FileFinder: ";
    private static final char WIN_PATH_SEP = ';';
    private static final char UNIX_PATH_SEP = ':';
    private static final char NO_DIGIT_WILDCARD = '\u0000';
    private List collectedFiles = null;
    static /* synthetic */ Class class$0;

    protected List getCollectedFiles() {
        return this.collectedFiles;
    }

    protected void setCollectedFiles(List newValue) {
        this.collectedFiles = newValue;
    }

    protected FileFinder() {
        this.setCollectedFiles(new ArrayList(100));
    }

    public static URL locateFile(String filename) {
        File aFile = null;
        aFile = new File(filename);
        if (FileFinder.fileExists(aFile)) {
            try {
                return aFile.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return FileFinder.locateFileOnClasspath(filename);
    }

    public static URL locateFileOnClasspath(String filename) {
        URL url;
        block11: {
            ClassLoader cl;
            block10: {
                cl = null;
                url = null;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.pf.file.FileFinder");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((cl = clazz.getClassLoader()) != null) break block10;
                if (DEBUG) {
                    FileFinder.debug("No classloader found !\n<P>");
                }
                return null;
            }
            try {
                url = cl.getResource(filename);
                if (url == null) {
                    if (DEBUG) {
                        FileFinder.debug("File '" + filename + "' not found on CLASSPATH !!!");
                    }
                    url = FileFinder.locateFileOnPath(filename, FileUtil.current().getClasspath());
                }
            }
            catch (Exception ex) {
                if (!DEBUG) break block11;
                FileFinder.logger().logException(ex);
            }
        }
        return url;
    }

    public static File findFileOnClasspath(String filename) {
        File file = null;
        URL url = null;
        url = FileFinder.locateFileOnClasspath(filename);
        if (url == null) {
            if (DEBUG) {
                FileFinder.debug("File '" + filename + "' not found on CLASSPATH !!!");
            }
        } else {
            file = new File(url.getFile());
            if (!FileFinder.fileExists(file)) {
                file = null;
            }
        }
        return file;
    }

    public static URL locateFileOnPath(String filename, String path) {
        if (filename == null || path == null) {
            return null;
        }
        char separator = File.pathSeparatorChar == ';' ? (char)':' : ';';
        String searchPath = path.replace(separator, File.pathSeparatorChar);
        Classpath classpath = new Classpath(searchPath);
        return FileFinder.locateFileOnPath(filename, classpath);
    }

    public static URL locateFileOnPath(String filename, Classpath path) {
        if (filename == null || path == null) {
            return null;
        }
        ClasspathElement cpElement = path.firstElementContaining(filename);
        if (cpElement == null) {
            return null;
        }
        URL url = cpElement.createURL(filename);
        if (url == null) {
            return null;
        }
        return url;
    }

    public static File findFileOnPath(String filename, String path) {
        URL url = FileFinder.locateFileOnPath(filename, path);
        if (url == null) {
            return null;
        }
        String name = url.getFile();
        name = FileFinder.str().cutHead(name, "file:/");
        if (name.startsWith("/")) {
            name = FileFinder.str().cutHead(name, "/");
        }
        return new File(name);
    }

    public static File findFile(String filename) {
        File aFile = null;
        aFile = new File(filename);
        if (FileFinder.fileExists(aFile)) {
            return aFile;
        }
        aFile = FileFinder.findFileOnClasspath(filename);
        return aFile;
    }

    public static File[] findFiles(String dir, String pattern) {
        return FileFinder.findFiles(dir, pattern, true);
    }

    public static File[] findFiles(String dir, String pattern, boolean recursive) {
        return FileFinder.findFiles(dir, pattern, recursive, '\u0000');
    }

    public static File[] findFiles(String dir, String pattern, boolean recursive, char digitWildcard) {
        Character digitChar = null;
        if (dir == null) {
            throw new IllegalArgumentException("FileFinder.findFiles(): dir is null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("FileFinder.findFiles(): pattern is null");
        }
        if (digitWildcard != '\u0000') {
            digitChar = new Character(digitWildcard);
        }
        FileFinder finder = new FileFinder();
        return finder.collectFiles(dir, pattern, recursive, digitChar);
    }

    public static File[] findFiles(String searchPattern) {
        return FileFinder.findFiles(searchPattern, '\u0000');
    }

    public static File[] findFiles(String searchPattern, char digitWildcard) {
        Character digitChar = null;
        if (searchPattern == null) {
            throw new IllegalArgumentException("FileFinder.findFiles(): searchPattern is null");
        }
        if (digitWildcard != '\u0000') {
            digitChar = new Character(digitWildcard);
        }
        FileFinder finder = new FileFinder();
        return finder.collectFiles(searchPattern, digitChar);
    }

    public static File[] findDirectories(String startDir, String pattern, boolean recursive, char digitWildcard) {
        Character digitChar = null;
        if (startDir == null) {
            throw new IllegalArgumentException("FileFinder.findDirectories(): dir is null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("FileFinder.findDirectories(): pattern is null");
        }
        if (digitWildcard != '\u0000') {
            digitChar = new Character(digitWildcard);
        }
        FileFinder finder = new FileFinder();
        return finder.collectDirectories(startDir, pattern, recursive, digitChar);
    }

    public static File[] findDirectories(String startDir, String pattern, boolean recursive) {
        return FileFinder.findDirectories(startDir, pattern, recursive, '\u0000');
    }

    public static File[] findDirectories(String startDir, String pattern) {
        return FileFinder.findDirectories(startDir, pattern, true, '\u0000');
    }

    private static boolean fileExists(File file) {
        boolean success = false;
        if (file != null) {
            try {
                FileLocator locator = FileLocator.create(file);
                success = locator.exists();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    private static Logger logger() {
        return LoggerProvider.getLogger();
    }

    private static StringUtil str() {
        return StringUtil.current();
    }

    private static void debug(String text) {
        FileFinder.logger().logDebug(DEBUG_PREFIX + text);
    }

    public boolean handleFile(File file) {
        this.getCollectedFiles().add(file);
        return true;
    }

    public boolean handleException(Exception ex, File file) {
        if (DEBUG) {
            FileFinder.debug("Problem with file '" + file + "'");
            FileFinder.debug(ex.toString());
        }
        return false;
    }

    public boolean directoryEnd(File dir) {
        return true;
    }

    public boolean directoryStart(File dir, int count) {
        return true;
    }

    protected File[] collectDirectories(String dir, String pattern, boolean recursive, Character digitWildcard) {
        FileWalker fileWalker = new FileWalker(this);
        if (digitWildcard != null) {
            fileWalker.setDigitWildcardChar(digitWildcard.charValue());
        }
        ExtendedFileFilter filter = new ExtendedFileFilter(pattern);
        filter.setRestrictiveMode(false);
        fileWalker.walkThroughDirectories(dir, filter, recursive);
        return this.getCollectedFilesArray();
    }

    protected File[] collectFiles(String dir, String pattern, boolean recursive, Character digitWildcard) {
        FileWalker fileWalker = new FileWalker(this);
        if (digitWildcard != null) {
            fileWalker.setDigitWildcardChar(digitWildcard.charValue());
        }
        fileWalker.walkThrough(dir, pattern, recursive);
        return this.getCollectedFilesArray();
    }

    protected File[] collectFiles(String pattern, Character digitWildcard) {
        FileWalker fileWalker = new FileWalker(this);
        if (digitWildcard != null) {
            fileWalker.setDigitWildcardChar(digitWildcard.charValue());
        }
        fileWalker.walkThrough(pattern);
        return this.getCollectedFilesArray();
    }

    protected File[] getCollectedFilesArray() {
        List list = this.getCollectedFiles();
        return list.toArray(new File[list.size()]);
    }
}

