/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.pf.file.Classpath;
import org.pf.file.FileLocator;
import org.pf.file.LineProcessor;
import org.pf.reflect.Dynamic;
import org.pf.reflect.ReflectUtil;
import org.pf.text.StringFilter;
import org.pf.text.StringPattern;
import org.pf.text.StringUtil;
import org.pf.textx.BasicVariableContainer;
import org.pf.textx.TextEngine;
import org.pf.textx.TextReplacementException;
import org.pf.util.OrderedSet;
import org.pf.util.SysUtil;

public class FileUtil {
    private static final String SYS_PROP_CLASSPATH = "java.class.path";
    private static final String SYS_PROP_EXT_DIRS = "java.ext.dirs";
    private static final String JAR_FILE_EXTENSION = "jar";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final String DEFAULT_TEMP_FILE_PREFIX = "PFFU";
    protected static final String FILE_PROTOCOL_INDICATOR = "file:";
    protected static final StringPattern LOCAL_PATTERN = StringPattern.create("*file:?*");
    protected static final StringPattern REMOTE_PATTERN = StringPattern.create("*?://?*");
    protected static final StringPattern JAR_PATTERN = StringPattern.create("*jar:*:*!/*");
    protected static final StringPattern DRIVE_LETTER_PATTERN_1 = StringPattern.create("?:");
    protected static final StringPattern DRIVE_LETTER_PATTERN_2 = StringPattern.create("?:?*");
    protected static final StringPattern WINDOWS_DRIVE_PATTERN_1 = StringPattern.create("\\?:*");
    protected static final StringPattern WINDOWS_DRIVE_PATTERN_2 = StringPattern.create("/?:*");
    private static final FileUtil current = new FileUtil();
    private Classpath calculatedClasspath = null;
    private String classpathString = null;
    private Classpath systemClasspath = null;

    protected FileUtil() {
    }

    public static FileUtil current() {
        return current;
    }

    public void copyStream(InputStream inStream, OutputStream outStream) throws IOException {
        this.copyStream(inStream, outStream, 1024);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyStream(InputStream inStream, OutputStream outStream, int bufSize) throws IOException {
        byte[] buffer = new byte[bufSize];
        try {
            int count = inStream.read(buffer);
            while (count > -1) {
                outStream.write(buffer, 0, count);
                count = inStream.read(buffer);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.close(inStream);
            this.close(outStream);
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.close(inStream);
        }
        this.close(outStream);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyFile(File sourceFile, File destFile, boolean preserveTimestamp) throws IOException {
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = new FileInputStream(sourceFile);
            outStream = new FileOutputStream(destFile);
            this.copyStream(inStream, outStream);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.close(inStream);
            this.close(outStream);
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.close(inStream);
        }
        this.close(outStream);
        if (preserveTimestamp) {
            destFile.setLastModified(sourceFile.lastModified());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyFile(FileLocator sourceFile, File destFile, boolean preserveTimestamp) throws IOException {
        InputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = sourceFile.getInputStream();
            outStream = new FileOutputStream(destFile);
            this.copyStream(inStream, outStream);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.close(inStream);
            this.close(outStream);
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.close(inStream);
        }
        this.close(outStream);
        if (preserveTimestamp) {
            destFile.setLastModified(sourceFile.lastModified());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyFile(URL source, File destFile) throws IOException {
        InputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = source.openStream();
            outStream = new FileOutputStream(destFile);
            this.copyStream(inStream, outStream);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.close(inStream);
            this.close(outStream);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.close(inStream);
        }
        this.close(outStream);
    }

    public void copyFile(File sourceFile, File destFile) throws IOException {
        this.copyFile(sourceFile, destFile, false);
    }

    public void copyFile(String sourceFilename, String destFilename, boolean preserveTimestamp) throws IOException {
        this.copyFile(new File(sourceFilename), new File(destFilename), preserveTimestamp);
    }

    public void copyFile(String sourceFilename, String destFilename) throws IOException {
        this.copyFile(sourceFilename, destFilename, false);
    }

    public String readTextFrom(InputStream inStream) throws IOException {
        StringWriter writer = new StringWriter(1024);
        this.copyText(inStream, writer);
        return writer.toString();
    }

    public String readTextFrom(String filename) throws IOException {
        FileInputStream inStream = new FileInputStream(filename);
        return this.readTextFrom(inStream);
    }

    public String readTextFrom(File file) throws IOException {
        FileInputStream inStream = new FileInputStream(file);
        return this.readTextFrom(inStream);
    }

    public String readTextFrom(FileLocator fileLocator) throws IOException {
        return this.readTextFrom(fileLocator.getInputStream());
    }

    public String[] readTextLinesFrom(String filename) throws IOException {
        File file = new File(filename);
        return this.readTextLinesFrom(file);
    }

    public String[] readTextLinesFrom(File file) throws IOException {
        FileInputStream inStream = new FileInputStream(file);
        return this.readTextLinesFrom(inStream);
    }

    public String[] readTextLinesFrom(FileLocator fileLocator) throws IOException {
        return this.readTextLinesFrom(fileLocator.getInputStream());
    }

    public String[] readTextLinesFrom(InputStream inStream) throws IOException {
        return this.readTextLinesFrom(new InputStreamReader(inStream));
    }

    public String[] readTextLinesFrom(Reader reader) throws IOException {
        return this.basicReadTextLinesFrom(reader, null);
    }

    public String[] readTextLinesFrom(String filename, StringFilter filter) throws IOException {
        File file = new File(filename);
        return this.readTextLinesFrom(file, filter);
    }

    public String[] readTextLinesFrom(File file, StringFilter filter) throws IOException {
        FileInputStream inStream = new FileInputStream(file);
        return this.readTextLinesFrom(inStream, filter);
    }

    public String[] readTextLinesFrom(FileLocator fileLocator, StringFilter filter) throws IOException {
        return this.readTextLinesFrom(fileLocator.getInputStream(), filter);
    }

    public String[] readTextLinesFrom(InputStream inStream, StringFilter filter) throws IOException {
        return this.readTextLinesFrom(new InputStreamReader(inStream), filter);
    }

    public String[] readTextLinesFrom(Reader reader, StringFilter filter) throws IOException {
        return this.basicReadTextLinesFrom(reader, filter);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyText(Reader reader, final StringWriter writer) throws IOException {
        BufferedReader bufReader = new BufferedReader(reader);
        try {
            LineProcessor processor = new LineProcessor(){

                public boolean processLine(String line, int lineNo) {
                    if (lineNo > 1) {
                        writer.write(LINE_SEPARATOR);
                    }
                    writer.write(line);
                    return true;
                }
            };
            this.processTextLines(bufReader, processor);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            bufReader.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        bufReader.close();
    }

    public void processTextLines(String filename, LineProcessor processor) throws IOException {
        if (filename == null) {
            throw new IllegalArgumentException("filename must not be null");
        }
        FileInputStream inStream = new FileInputStream(filename);
        this.processTextLines(inStream, processor);
    }

    public void processTextLines(InputStream inStream, LineProcessor processor) throws IOException {
        if (inStream == null) {
            throw new IllegalArgumentException("inStream must not be null");
        }
        InputStreamReader reader = new InputStreamReader(inStream);
        this.processTextLines(reader, processor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processTextLines(Reader reader, LineProcessor processor) throws IOException {
        int counter = 0;
        boolean continue_reading = true;
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("processor must not be null");
        }
        BufferedReader bufReader = new BufferedReader(reader);
        try {
            String line;
            while (continue_reading && bufReader.ready() && (line = bufReader.readLine()) != null) {
                continue_reading = processor.processLine(line, ++counter);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.close(bufReader);
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.close(bufReader);
        }
    }

    public boolean close(InputStream stream) {
        if (stream == null) {
            return false;
        }
        try {
            stream.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean close(OutputStream stream) {
        if (stream == null) {
            return false;
        }
        try {
            stream.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean close(Reader reader) {
        if (reader == null) {
            return false;
        }
        try {
            reader.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean close(Writer writer) {
        if (writer == null) {
            return false;
        }
        try {
            writer.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean close(ZipFile zipFile) {
        if (zipFile == null) {
            return false;
        }
        try {
            zipFile.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String standardize(String filename) {
        if (filename == null) {
            return null;
        }
        if (this.isRemote(filename)) {
            return filename;
        }
        return this.standardizeFilename(filename);
    }

    public String[] standardize(String[] filenames) {
        if (filenames == null) {
            return null;
        }
        String[] names = new String[filenames.length];
        int i = 0;
        while (i < filenames.length) {
            names[i] = this.standardize(filenames[i]);
            ++i;
        }
        return names;
    }

    public String javaFilename(String filename) {
        if (filename == null) {
            return null;
        }
        return filename.replace('\\', '/');
    }

    public String[] javaFilenames(String[] filenames) {
        if (filenames == null) {
            return null;
        }
        String[] newNames = new String[filenames.length];
        int i = 0;
        while (i < filenames.length) {
            newNames[i] = this.javaFilename(filenames[i]);
            ++i;
        }
        return newNames;
    }

    public String getClasspath() {
        Classpath classpath;
        if (this.classpathString == null && (classpath = this.calculateClasspath()) != null) {
            this.classpathString = classpath.toString();
        }
        return this.classpathString;
    }

    public Classpath calculateClasspath() {
        if (this.calculatedClasspath == null) {
            this.calculatedClasspath = SysUtil.current().isEclipse() ? this.calculateEclipseClasspath() : new Classpath(this.getClasspathFromSystemProperty());
        }
        return this.calculatedClasspath;
    }

    public Classpath getLookupPath(String sysPropName) {
        if (!this.str().isNullOrEmpty(sysPropName)) {
            String propValue = System.getProperty(sysPropName);
            if (!this.str().isNullOrEmpty(propValue)) {
                return this.determineLookupClasspath(sysPropName);
            }
        }
        if (SysUtil.current().isEclipse()) {
            return this.calculateClasspath();
        }
        return this.determineLookupClasspath(sysPropName);
    }

    public File copyToTempFile(InputStream inStream) throws IOException {
        return this.copyToTempFile(inStream, DEFAULT_TEMP_FILE_PREFIX);
    }

    public File copyToTempFile(InputStream inStream, String filePrefix) throws IOException {
        return this.copyToTempFile(inStream, filePrefix, null);
    }

    public File copyToTempFile(InputStream inStream, String filePrefix, String fileSuffix) throws IOException {
        return this.copyToTempFile(inStream, filePrefix, fileSuffix, true);
    }

    public File copyToTempFile(InputStream inStream, String filePrefix, String fileSuffix, boolean deleteOnExit) throws IOException {
        File tempFile = File.createTempFile(filePrefix, fileSuffix);
        FileOutputStream outStream = new FileOutputStream(tempFile);
        this.copyStream(inStream, outStream);
        if (deleteOnExit) {
            tempFile.deleteOnExit();
        }
        return tempFile;
    }

    public File copyToTempFile(String filename, String filePrefix, String fileSuffix, boolean deleteOnExit) throws IOException {
        InputStream inStream;
        if (filename == null) {
            throw new IllegalArgumentException("<filename> must not be null!");
        }
        if (filePrefix == null) {
            throw new IllegalArgumentException("<filePrefix> must not be null!");
        }
        if (this.isLocal(filename)) {
            inStream = new FileInputStream(filename);
        } else {
            URL url = new URL(filename);
            inStream = url.openStream();
        }
        if (inStream == null) {
            return null;
        }
        return this.copyToTempFile(inStream, filePrefix, fileSuffix, deleteOnExit);
    }

    public boolean isLocalFileURL(String filename) {
        if (filename == null) {
            return false;
        }
        return LOCAL_PATTERN.matches(filename);
    }

    public boolean isLocal(String filename) {
        if (filename == null) {
            return false;
        }
        if (this.isLocalFileURL(filename)) {
            return true;
        }
        return !this.isRemote(filename);
    }

    public boolean isRemote(String filename) {
        if (filename == null) {
            return false;
        }
        return REMOTE_PATTERN.matches(filename);
    }

    public boolean isInsideJavaArchive(String filename) {
        if (filename == null) {
            return false;
        }
        return JAR_PATTERN.matches(filename);
    }

    public String convertToURLSyntax(String filename) {
        if (filename == null || this.isRemote(filename) || this.isLocalFileURL(filename)) {
            return filename;
        }
        StringBuffer buffer = new StringBuffer(filename.length() + FILE_PROTOCOL_INDICATOR.length() + 3);
        buffer.append(FILE_PROTOCOL_INDICATOR);
        if (DRIVE_LETTER_PATTERN_2.matches(filename)) {
            buffer.append(File.separatorChar);
        }
        buffer.append(filename);
        return buffer.toString();
    }

    public String convertFromURLSyntax(String filename) {
        if (filename == null) {
            return null;
        }
        if (LOCAL_PATTERN.matches(filename)) {
            String newStr = filename.substring(FILE_PROTOCOL_INDICATOR.length());
            if (WINDOWS_DRIVE_PATTERN_1.matches(newStr) || WINDOWS_DRIVE_PATTERN_2.matches(newStr)) {
                newStr = newStr.substring(1);
            }
            return newStr;
        }
        return filename;
    }

    public File convertFromURLSyntax(File file) {
        return new File(this.convertFromURLSyntax(file.getPath()));
    }

    protected void copyText(InputStream inStream, StringWriter writer) throws IOException {
        this.copyText(new InputStreamReader(inStream), writer);
    }

    protected String standardizeFilename(String filename) {
        filename = this.javaFilename(filename);
        boolean startedFromRoot = filename.startsWith("/");
        String[] nameElements = this.str().parts(filename, "/");
        if (nameElements.length > 0) {
            boolean hasDriveLetter = false;
            int i = 0;
            while (i < nameElements.length) {
                if (DRIVE_LETTER_PATTERN_1.matches(nameElements[0])) {
                    nameElements[0] = nameElements[0].toUpperCase();
                    hasDriveLetter = true;
                }
                ++i;
            }
            if (!hasDriveLetter && startedFromRoot) {
                nameElements = this.str().append(new String[]{""}, nameElements);
            }
            boolean isAbsolute = hasDriveLetter || startedFromRoot;
            i = 0;
            while (i < nameElements.length) {
                int index;
                if (".".equals(nameElements[i])) {
                    nameElements[i] = null;
                } else if ("..".equals(nameElements[i]) && (index = this.indexOfPreceedingNotNullElement(nameElements, i - 1)) >= 0 && (index > 0 || !isAbsolute)) {
                    nameElements[i] = null;
                    nameElements[index] = null;
                }
                ++i;
            }
            nameElements = this.str().removeNull(nameElements);
            return this.str().asString(nameElements, "/");
        }
        return "";
    }

    protected int indexOfPreceedingNotNullElement(String[] elements, int start) {
        int i = start;
        while (i >= 0) {
            if (elements[i] != null) {
                if ("..".equals(elements[i])) {
                    return -1;
                }
                return i;
            }
            --i;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String classpathFromManifest(String jarFilename) {
        block14: {
            block13: {
                try {
                    jarFile = new JarFile(jarFilename);
                }
                catch (IOException e) {
                    return null;
                }
                try {
                    try {
                        manifest = jarFile.getManifest();
                        if (manifest == null) {
lbl11:
                            // 3 sources

                            while (true) {
                                var7_6 = null;
                                break block13;
                                break;
                            }
                        }
                        attrs = manifest.getMainAttributes();
                        if (attrs == null) ** GOTO lbl11
                        classpath = attrs.getValue("Class-Path");
                        break block14;
                    }
                    catch (IOException e1) {
                        ** continue;
                    }
                }
                catch (Throwable var8_14) {
                    var7_7 = null;
                    try {
                        jarFile.close();
                        throw var8_14;
                    }
                    catch (Exception var9_10) {
                        // empty catch block
                    }
                    throw var8_14;
                }
            }
            ** try [egrp 3[TRYBLOCK] [6 : 72->79)] { 
lbl31:
            // 1 sources

            jarFile.close();
            return null;
lbl33:
            // 1 sources

            catch (Exception var9_9) {
                // empty catch block
            }
            return null;
        }
        var7_8 = null;
        try {}
        catch (Exception var9_11) {
            return classpath;
        }
        jarFile.close();
        return classpath;
    }

    protected String constructClasspathFrom(String jarFilename) {
        String classpath = this.classpathFromManifest(jarFilename);
        if (classpath != null) {
            classpath = String.valueOf(jarFilename) + " " + classpath;
            String[] elements = this.str().parts(classpath, " ");
            classpath = this.str().asString(elements, File.pathSeparator);
        }
        return classpath;
    }

    protected Classpath calculateEclipseClasspath() {
        try {
            OrderedSet elements = new OrderedSet(50);
            ClassLoader classLoader = this.getClass().getClassLoader();
            Object bundleLoader = this.reflect().getValueOf(classLoader, "delegate");
            this.appendClasspathEntriesFrom(elements, bundleLoader);
            return new Classpath(elements);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void appendClasspathEntriesFrom(Collection elements, Object bundleLoader) {
        try {
            Object[] requiredBundles;
            int i;
            Object classloader = this.reflect().getValueOf(bundleLoader, "classloader");
            if (classloader == null) {
                return;
            }
            Object[] classpathEntries = (Object[])this.reflect().getValueOf(classloader, "classpathEntries");
            if (classpathEntries != null) {
                i = 0;
                while (i < classpathEntries.length) {
                    Object bundlefile = this.reflect().getValueOf(classpathEntries[i], "bundlefile");
                    File file = (File)Dynamic.invoke(bundlefile, "getBaseFile");
                    elements.add(file.getPath());
                    ++i;
                }
            }
            if ((requiredBundles = (Object[])this.reflect().getValueOf(bundleLoader, "requiredBundles")) != null) {
                i = 0;
                while (i < requiredBundles.length) {
                    Object bundleLoader2 = Dynamic.invoke(requiredBundles[i], "getBundleLoader");
                    this.appendClasspathEntriesFrom(elements, bundleLoader2);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getClasspathFromSystemProperty() {
        String suffix;
        String classpath = System.getProperty(SYS_PROP_CLASSPATH);
        String[] elements = this.str().parts(classpath, File.pathSeparator);
        if (elements.length == 1 && JAR_FILE_EXTENSION.equalsIgnoreCase(suffix = this.str().cutHead(elements[0], ".")) && (classpath = this.constructClasspathFrom(elements[0])) == null) {
            classpath = elements[0];
        }
        return classpath;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String[] basicReadTextLinesFrom(Reader reader, final StringFilter filter) throws IOException {
        final ArrayList lines = new ArrayList(100);
        BufferedReader bufReader = new BufferedReader(reader);
        try {
            LineProcessor processor = new LineProcessor(){

                public boolean processLine(String line, int lineNo) {
                    if (filter == null || filter.matches(line)) {
                        lines.add(line);
                    }
                    return true;
                }
            };
            this.processTextLines(bufReader, processor);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            bufReader.close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        bufReader.close();
        return this.str().asStrings(lines);
    }

    protected Classpath determineLookupClasspath(String sysPropName) {
        String classpath = null;
        if (!this.str().isNullOrEmpty(sysPropName)) {
            classpath = System.getProperty(sysPropName);
        }
        if (!this.str().isNullOrBlank(classpath) && (classpath = this.createClasspathFrom(classpath)) != null) {
            return new Classpath(classpath);
        }
        return this.createSystemClasspath();
    }

    protected Classpath createSystemClasspath() {
        if (this.systemClasspath == null) {
            String classpath = System.getProperty(SYS_PROP_EXT_DIRS, "");
            if (!this.str().isNullOrEmpty(classpath)) {
                classpath = String.valueOf(classpath) + File.pathSeparator;
            }
            classpath = String.valueOf(classpath) + this.getClasspath();
            this.systemClasspath = new Classpath(classpath);
        }
        return this.systemClasspath;
    }

    protected String createClasspathFrom(String path) {
        BasicVariableContainer varResolver = new BasicVariableContainer(System.getProperties());
        TextEngine textEngine = new TextEngine(varResolver);
        textEngine.setVarStartPrefix(new Character('$'));
        textEngine.setVarStartDelimiter('{');
        textEngine.setVarEndDelimiter('}');
        textEngine.setSpecialNameCharacters(".");
        try {
            return textEngine.completeText(path);
        }
        catch (TextReplacementException e) {
            return path;
        }
    }

    protected StringUtil str() {
        return StringUtil.current();
    }

    protected ReflectUtil reflect() {
        return ReflectUtil.current();
    }
}

