/*
 * Decompiled with CFR 0.152.
 */
package org.pf.file;

import java.io.File;
import java.io.FilenameFilter;
import org.pf.file.AFileProcessor;
import org.pf.file.ExtendedFileFilter;
import org.pf.file.FileHandler;

public class FileWalker {
    public static final char PATTERN_SEPARATOR_CHAR = ';';
    public static final String PATTERN_SEPARATOR = ";";
    public static final String RECURSIVE_DIR_WILDCARD = "**";
    private static final FilenameFilter DIRECTORIES_ONLY_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            File file = new File(dir, name);
            return file.isDirectory();
        }
    };
    private FileHandler fileHandler = null;
    private AFileProcessor fileProcessor = null;
    private boolean goOn = true;
    private Character digitWildcard = null;

    protected FileHandler getFileHandler() {
        return this.fileHandler;
    }

    protected void setFileHandler(FileHandler newValue) {
        this.fileHandler = newValue;
    }

    protected AFileProcessor getFileProcessor() {
        return this.fileProcessor;
    }

    protected void setFileProcessor(AFileProcessor newValue) {
        this.fileProcessor = newValue;
    }

    protected boolean getGoOn() {
        return this.goOn;
    }

    protected void setGoOn(boolean newValue) {
        this.goOn = newValue;
    }

    protected Character getDigitWildcard() {
        return this.digitWildcard;
    }

    protected void setDigitWildcard(Character newValue) {
        this.digitWildcard = newValue;
    }

    public FileWalker(AFileProcessor processor) {
        this.setFileProcessor(processor);
    }

    public FileWalker(FileHandler handler) {
        this.setFileHandler(handler);
    }

    public FileWalker(FileHandler handler, char digitWildcard) {
        this(handler);
        this.setDigitWildcardChar(digitWildcard);
    }

    public long walkThrough(String dir, String pattern, boolean recursive) {
        ExtendedFileFilter filter = null;
        this.setGoOn(true);
        filter = this.createFileFilter();
        filter.addPatterns(pattern);
        if (recursive) {
            filter.alwaysIncludeDirectories();
        } else {
            filter.alwaysExcludeDirectories();
        }
        return this.walkThrough(dir, filter, recursive);
    }

    public long walkThrough(String searchPattern) {
        boolean recursive = false;
        if (searchPattern == null) {
            return 0L;
        }
        File file = new File(searchPattern);
        String fileMatchPattern = file.getName();
        String dir = file.getParent();
        if (dir.endsWith(RECURSIVE_DIR_WILDCARD)) {
            recursive = true;
            file = new File(dir);
            dir = file.getParent();
        }
        return this.walkThrough(dir, fileMatchPattern, recursive);
    }

    public long walkThrough(String dir, FilenameFilter filter, boolean recursive) {
        long counter = 0L;
        File directory = null;
        File file = null;
        File[] files = null;
        int index = 0;
        directory = new File(dir);
        files = directory.listFiles(filter);
        if (files == null) {
            return counter;
        }
        this.setGoOn(this.directoryStart(directory, files.length));
        if (!this.getGoOn()) {
            return counter;
        }
        index = 0;
        while (index < files.length) {
            file = files[index];
            if (file.isDirectory()) {
                if (recursive) {
                    counter += this.walkThrough(file.getPath(), filter, recursive);
                }
            } else {
                this.setGoOn(this.handleFile(file));
                ++counter;
            }
            if (!this.getGoOn()) {
                return counter;
            }
            ++index;
        }
        this.setGoOn(this.directoryEnd(directory));
        return counter;
    }

    public long walkThroughDirectories(String startDir, FilenameFilter filter, boolean recursive) {
        File directory = new File(startDir);
        return this.scanDirectories(directory, filter, recursive);
    }

    public void setDigitWildcardChar(char digitWildcard) {
        if (digitWildcard <= '\u0000') {
            this.setDigitWildcard(null);
        } else {
            this.setDigitWildcard(new Character(digitWildcard));
        }
    }

    protected long scanDirectories(File startDir, FilenameFilter filter, boolean recursive) {
        long counter = 0L;
        File[] directories = startDir.listFiles(DIRECTORIES_ONLY_FILTER);
        if (directories == null) {
            return counter;
        }
        this.setGoOn(this.directoryStart(startDir, directories.length));
        if (!this.getGoOn()) {
            return counter;
        }
        int i = 0;
        while (i < directories.length) {
            File dir = directories[i];
            if (filter.accept(startDir, dir.getName())) {
                this.setGoOn(this.handleFile(dir));
                ++counter;
            }
            if (this.getGoOn() && recursive) {
                counter += this.scanDirectories(dir, filter, recursive);
            }
            if (!this.getGoOn()) {
                return counter;
            }
            ++i;
        }
        this.setGoOn(this.directoryEnd(startDir));
        return counter;
    }

    protected char getDigitWildcardChar() {
        if (this.hasDigitWildcard()) {
            return this.getDigitWildcard().charValue();
        }
        return '\u0000';
    }

    protected boolean hasDigitWildcard() {
        return this.getDigitWildcard() != null;
    }

    protected ExtendedFileFilter createFileFilter() {
        if (this.hasDigitWildcard()) {
            return new ExtendedFileFilter(this.getDigitWildcardChar(), this.restrictedWilcardMatch());
        }
        return new ExtendedFileFilter(this.restrictedWilcardMatch());
    }

    protected boolean restrictedWilcardMatch() {
        return false;
    }

    protected boolean handleFile(File file) {
        if (this.getFileProcessor() != null) {
            return this.getFileProcessor().processFile(file);
        }
        return this.getFileHandler().handleFile(file);
    }

    protected boolean directoryEnd(File dir) {
        if (this.getFileProcessor() != null) {
            return true;
        }
        return this.getFileHandler().directoryEnd(dir);
    }

    protected boolean directoryStart(File dir, int count) {
        if (this.getFileProcessor() != null) {
            return true;
        }
        return this.getFileHandler().directoryStart(dir, count);
    }
}

