/*
 * Decompiled with CFR 0.152.
 */
package org.pf.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.pf.net.SocketConnection;
import org.pf.util.ExceptionHandler;

public class BinarySocketConnection
extends SocketConnection {
    private BufferedInputStream reader = null;
    private BufferedOutputStream writer = null;

    protected BufferedInputStream reader() {
        return this.reader;
    }

    protected void reader(BufferedInputStream newValue) {
        this.reader = newValue;
    }

    protected BufferedOutputStream writer() {
        return this.writer;
    }

    protected void writer(BufferedOutputStream newValue) {
        this.writer = newValue;
    }

    public BinarySocketConnection(Socket openSocket) {
        super(openSocket);
    }

    public BinarySocketConnection(Socket openSocket, ExceptionHandler exHandler) {
        super(openSocket, exHandler);
    }

    public byte[] getData() {
        byte[] data = null;
        int numberOfBytes = 0;
        if (this.canRead()) {
            try {
                int b = this.getReader().read();
                numberOfBytes = this.getReader().available();
                if (numberOfBytes > 0) {
                    data = new byte[numberOfBytes + 1];
                    data[0] = (byte)b;
                    this.getReader().read(data, 1, numberOfBytes);
                } else {
                    data = null;
                }
            }
            catch (SocketException ex) {
                this.isOpen(false);
            }
            catch (IOException e) {
                this.exceptionOccurred(e);
            }
        }
        return data;
    }

    public boolean writeData(byte[] bytes) {
        try {
            this.getWriter().write(bytes);
            this.getWriter().flush();
            return true;
        }
        catch (Exception e) {
            this.exceptionOccurred(e);
            return false;
        }
    }

    public void close() {
        super.close();
        this.closeReader();
        this.closeWriter();
    }

    protected boolean canRead() {
        return this.isOpen() && this.getReader() != null;
    }

    protected boolean hasReader() {
        return this.reader() != null;
    }

    protected boolean hasWriter() {
        return this.writer() != null;
    }

    protected BufferedInputStream getReader() {
        if (!this.hasReader()) {
            try {
                this.reader(new BufferedInputStream(this.socket().getInputStream()));
            }
            catch (IOException e) {
                this.exceptionOccurred(e);
            }
        }
        return this.reader();
    }

    protected BufferedOutputStream getWriter() {
        if (!this.hasWriter()) {
            try {
                this.writer(new BufferedOutputStream(this.socket().getOutputStream()));
            }
            catch (IOException e) {
                this.exceptionOccurred(e);
            }
        }
        return this.writer();
    }

    protected void closeReader() {
        if (this.hasReader()) {
            try {
                this.reader().close();
            }
            catch (IOException e) {
                this.exceptionOccurred(e);
            }
        }
        this.reader(null);
    }

    protected void closeWriter() {
        if (this.hasWriter()) {
            try {
                this.writer().close();
            }
            catch (IOException e) {
                this.exceptionOccurred(e);
            }
            this.writer(null);
        }
    }
}

