/*
 * Decompiled with CFR 0.152.
 */
package org.pf.net;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.pf.net.TextSocketConnection;
import org.pf.util.ExceptionHandler;
import org.pf.util.ExceptionIgnorer;

public class ConnectionPool
extends ExceptionIgnorer {
    private static final int POOLSIZE_MINIMUM = 2;
    private static final int POOLSIZE_DEFAULT = 10;
    private volatile boolean creatingConnection = false;
    private int poolSize = 10;
    private int usedSlots = 0;
    private TextSocketConnection[] pool = null;
    private String hostname = null;
    private int port = 21000;

    protected int poolSize() {
        return this.poolSize;
    }

    protected void poolSize(int newValue) {
        this.poolSize = newValue;
    }

    protected synchronized int usedSlots() {
        return this.usedSlots;
    }

    protected void usedSlots(int newValue) {
        this.usedSlots = newValue;
    }

    protected TextSocketConnection[] pool() {
        return this.pool;
    }

    protected void pool(TextSocketConnection[] newValue) {
        this.pool = newValue;
    }

    protected String hostname() {
        return this.hostname;
    }

    protected void hostname(String newValue) {
        this.hostname = newValue;
    }

    protected int port() {
        return this.port;
    }

    protected void port(int newValue) {
        this.port = newValue;
    }

    public ConnectionPool(String hostname, int port) {
        this(hostname, port, 10);
    }

    public ConnectionPool(String hostname, int port, int poolLimit) {
        this(hostname, port, null);
    }

    public ConnectionPool(String hostname, int port, ExceptionHandler exHandler) {
        this(hostname, port, 2, null);
    }

    public ConnectionPool(String hostname, int port, int poolLimit, ExceptionHandler exHandler) {
        super(exHandler);
        this.hostname(hostname);
        this.port(port);
        this.initPool(Math.max(2, poolLimit));
    }

    public TextSocketConnection getConnection() {
        TextSocketConnection conn = null;
        while (conn == null) {
            conn = this.findUnusedConnectionInPool();
            if (conn != null || !this.wantToCreateNewConnection() || (conn = this.newConnection()) == null) continue;
            conn.inUse(true);
            this.addToPool(conn);
            this.creatingConnection = false;
        }
        return conn;
    }

    public void returnConnection(TextSocketConnection connection) {
        connection.inUse(false);
    }

    public void createConnections(int numberOfConnections) {
        int create = Math.min(this.poolSize(), numberOfConnections);
        int i = 1;
        while (i <= create) {
            this.createConnectionInPool();
            ++i;
        }
    }

    public int numberOfPooledConnections() {
        return this.usedSlots();
    }

    protected TextSocketConnection newConnection() {
        TextSocketConnection conn = null;
        Socket socket = this.openSocket();
        if (socket != null) {
            conn = new TextSocketConnection(socket, this.exceptionHandler());
        }
        return conn;
    }

    protected Socket openSocket() {
        Socket socket = null;
        try {
            socket = new Socket(this.hostname(), this.port());
        }
        catch (UnknownHostException e) {
            this.exceptionOccurred(e);
        }
        catch (IOException e) {
            this.exceptionOccurred(e);
        }
        return socket;
    }

    protected TextSocketConnection findUnusedConnectionInPool() {
        TextSocketConnection conn = null;
        int i = 0;
        while (i < this.poolSize) {
            conn = this.pool[i];
            if (conn != null) {
                if (conn.isClosed()) {
                    this.pool[i] = null;
                    this.decUsedSlots();
                } else if (conn.wantToUse()) {
                    return conn;
                }
            }
            ++i;
        }
        return null;
    }

    protected void addToPool(TextSocketConnection conn) {
        int i = 0;
        while (i < this.poolSize) {
            if (this.pool[i] == null) {
                this.pool[i] = conn;
                this.incUsedSlots();
                return;
            }
            ++i;
        }
    }

    protected synchronized boolean wantToCreateNewConnection() {
        if (this.creatingConnection) {
            return false;
        }
        if (this.poolIsFull()) {
            return false;
        }
        this.creatingConnection = true;
        return true;
    }

    protected boolean poolIsFull() {
        return this.usedSlots() == this.poolSize();
    }

    protected void initPool(int size) {
        this.poolSize(size);
        this.pool(new TextSocketConnection[size]);
        this.usedSlots(0);
    }

    protected void createConnectionInPool() {
        TextSocketConnection conn = this.newConnection();
        conn.getReader();
        conn.getWriter();
        conn.inUse(false);
        this.addToPool(conn);
    }

    protected synchronized void incUsedSlots() {
        ++this.usedSlots;
    }

    protected synchronized void decUsedSlots() {
        --this.usedSlots;
    }
}

