/*
 * Decompiled with CFR 0.152.
 */
package org.pf.net;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.pf.util.ExceptionHandler;
import org.pf.util.ExceptionIgnorer;

public class PortListener
extends ExceptionIgnorer {
    private ServerSocket serverSocket = null;

    protected ServerSocket serverSocket() {
        return this.serverSocket;
    }

    protected void serverSocket(ServerSocket newValue) {
        this.serverSocket = newValue;
    }

    public PortListener(int port) {
        this(port, null);
    }

    public PortListener(int port, ExceptionHandler handler) {
        super(handler);
        this.initialize(port);
    }

    public Socket waitForRequest() {
        Socket client = null;
        if (this.isOpen()) {
            try {
                client = this.serverSocket().accept();
            }
            catch (IOException e) {
                this.exceptionOccurred(e);
            }
        }
        return client;
    }

    public void close() {
        if (this.isOpen()) {
            try {
                this.serverSocket().close();
            }
            catch (IOException e) {
                this.exceptionOccurred(e);
            }
            this.serverSocket(null);
        }
    }

    public boolean isOpen() {
        return this.serverSocket() != null;
    }

    public int getPort() {
        if (this.isOpen()) {
            return this.serverSocket().getLocalPort();
        }
        return -1;
    }

    protected void initialize(int port) {
        try {
            this.serverSocket(new ServerSocket(port));
        }
        catch (IOException e) {
            this.exceptionOccurred(e);
        }
    }
}

