/*
 * Decompiled with CFR 0.152.
 */
package org.pf.net;

import java.net.Socket;
import org.pf.net.PortListener;
import org.pf.net.RequestProcessor;
import org.pf.net.SocketConnection;
import org.pf.util.ExceptionHandler;
import org.pf.util.ExceptionIgnorer;

public abstract class RequestServer
extends ExceptionIgnorer
implements Runnable {
    private PortListener portListener = null;
    private int port = 0;
    private boolean done = false;

    protected PortListener portListener() {
        return this.portListener;
    }

    protected void portListener(PortListener newValue) {
        this.portListener = newValue;
    }

    protected int port() {
        return this.port;
    }

    protected void port(int newValue) {
        this.port = newValue;
    }

    protected boolean done() {
        return this.done;
    }

    protected void done(boolean newValue) {
        this.done = newValue;
    }

    public RequestServer() {
    }

    public RequestServer(ExceptionHandler exHandler) {
        super(exHandler);
    }

    public RequestServer(int port) {
        this(port, null);
    }

    public RequestServer(int port, ExceptionHandler exHandler) {
        super(exHandler);
        this.port(port);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (!this.initialize()) return;
        try {
            this.listen();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.close();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.close();
            return;
        }
    }

    protected abstract RequestProcessor createRequestProcessor(SocketConnection var1);

    protected abstract SocketConnection createSocketConnection(Socket var1, ExceptionHandler var2);

    protected Thread createProcessingThread(RequestProcessor requestProcessor) {
        return new Thread(requestProcessor);
    }

    protected SocketConnection waitForRequestConnection() {
        Socket socket = this.portListener().waitForRequest();
        if (socket == null) {
            return null;
        }
        return this.createSocketConnection(socket, this.exceptionHandler());
    }

    protected Socket waitForRequest() {
        return this.portListener().waitForRequest();
    }

    protected boolean initialize() {
        PortListener listener = new PortListener(this.port(), this.exceptionHandler());
        this.portListener(listener);
        if (!this.portListener().isOpen()) {
            this.done(true);
        }
        return !this.done();
    }

    protected void listen() {
        while (!this.done()) {
            SocketConnection connection = this.waitForRequestConnection();
            if (connection == null) {
                this.done(true);
                continue;
            }
            RequestProcessor requestProcessor = this.createRequestProcessor(connection);
            Thread processingThread = this.createProcessingThread(requestProcessor);
            processingThread.start();
        }
    }

    protected void close() {
        if (this.portListener() != null) {
            this.portListener().close();
            this.portListener(null);
        }
    }
}

