/*
 * Decompiled with CFR 0.152.
 */
package org.pf.net;

import java.io.IOException;
import java.net.Socket;
import org.pf.util.ExceptionHandler;
import org.pf.util.ExceptionIgnorer;

public class SocketConnection
extends ExceptionIgnorer {
    private Socket socket = null;
    private boolean isOpen = true;
    private volatile boolean inUse = false;

    protected Socket socket() {
        return this.socket;
    }

    protected void socket(Socket newValue) {
        this.socket = newValue;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    protected void isOpen(boolean newValue) {
        this.isOpen = newValue;
    }

    protected synchronized boolean inUse() {
        return this.inUse;
    }

    protected synchronized void inUse(boolean newValue) {
        this.inUse = newValue;
    }

    public SocketConnection(Socket openSocket) {
        this(openSocket, null);
    }

    public SocketConnection(Socket openSocket, ExceptionHandler exHandler) {
        super(exHandler);
        this.socket(openSocket);
    }

    public void close() {
        this.isOpen(false);
        this.closeSocket();
    }

    protected synchronized boolean wantToUse() {
        if (this.inUse()) {
            return false;
        }
        if (this.isClosed()) {
            return false;
        }
        this.inUse(true);
        return true;
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    protected boolean hasSocket() {
        return this.socket() != null;
    }

    protected void closeSocket() {
        try {
            if (this.hasSocket()) {
                this.socket().close();
                this.socket(null);
            }
        }
        catch (IOException e) {
            this.exceptionOccurred(e);
        }
    }
}

