/*
 * Decompiled with CFR 0.152.
 */
package org.pf.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import org.pf.net.SocketConnection;
import org.pf.util.ExceptionHandler;

public class TextSocketConnection
extends SocketConnection {
    private BufferedReader reader = null;
    private PrintWriter writer = null;

    protected BufferedReader reader() {
        return this.reader;
    }

    protected void reader(BufferedReader newValue) {
        this.reader = newValue;
    }

    protected PrintWriter writer() {
        return this.writer;
    }

    protected void writer(PrintWriter newValue) {
        this.writer = newValue;
    }

    public TextSocketConnection(Socket openSocket) {
        super(openSocket);
    }

    public TextSocketConnection(Socket openSocket, ExceptionHandler exHandler) {
        super(openSocket, exHandler);
    }

    public void close() {
        super.close();
        this.closeReader();
        this.closeWriter();
    }

    public String readLine() {
        String line = null;
        if (this.canRead()) {
            try {
                line = this.getReader().readLine();
            }
            catch (SocketException ex) {
                this.isOpen(false);
            }
            catch (IOException e) {
                this.exceptionOccurred(e);
            }
        }
        return line;
    }

    public boolean write(String text) {
        boolean success = false;
        if (this.canWrite()) {
            this.getWriter().write(text);
            this.getWriter().flush();
            success = true;
        }
        return success;
    }

    public boolean writeLine(String line) {
        boolean success = false;
        if (this.canWrite()) {
            this.getWriter().write(line);
            this.getWriter().write(10);
            this.getWriter().flush();
            success = true;
        }
        return success;
    }

    protected BufferedReader getReader() {
        if (!this.hasReader() && this.hasSocket()) {
            try {
                InputStreamReader isr = new InputStreamReader(this.socket().getInputStream());
                BufferedReader r = new BufferedReader(isr);
                this.reader(r);
            }
            catch (IOException e) {
                this.exceptionOccurred(e);
            }
        }
        return this.reader();
    }

    protected PrintWriter getWriter() {
        if (!this.hasWriter() && this.hasSocket()) {
            try {
                OutputStreamWriter osw = new OutputStreamWriter(this.socket().getOutputStream());
                PrintWriter ps = new PrintWriter(osw);
                this.writer(ps);
            }
            catch (IOException e) {
                this.exceptionOccurred(e);
            }
        }
        return this.writer();
    }

    protected boolean hasReader() {
        return this.reader() != null;
    }

    protected boolean hasWriter() {
        return this.writer() != null;
    }

    protected boolean canRead() {
        return this.isOpen() && this.getReader() != null;
    }

    protected boolean canWrite() {
        return this.isOpen() && this.getWriter() != null;
    }

    protected void closeReader() {
        try {
            if (this.hasReader()) {
                this.reader().close();
                this.reader(null);
            }
        }
        catch (IOException e) {
            this.exceptionOccurred(e);
        }
    }

    protected void closeWriter() {
        if (this.hasWriter()) {
            this.writer().close();
            this.writer(null);
        }
    }
}

