/*
 * Decompiled with CFR 0.152.
 */
package org.pf.nls;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.pf.file.Classpath;
import org.pf.file.ClasspathElement;
import org.pf.file.FileFinder;
import org.pf.file.FileLocator;
import org.pf.nls.NLSUtil;
import org.pf.settings.Settings;
import org.pf.settings.rw.IniReaderWriter;
import org.pf.text.StringUtil;
import org.pf.util.CollectionUtil;

public class NLSIniFileDetector {
    public static final boolean DEBUG = "true".equals(System.getProperty("org.pf.nls.NLSIniFileDetector.debug", "false"));
    public static final String DEFAULT_FILE_EXTENSTION = ".ini";
    protected static final String FILE_MAPPING_SECTION = "nls-files";
    private Map fileMappings = null;
    private Classpath lookupPath = null;

    protected Map getFileMappings() {
        return this.fileMappings;
    }

    protected void setFileMappings(Map newValue) {
        this.fileMappings = newValue;
    }

    protected Classpath getLookupPath() {
        return this.lookupPath;
    }

    protected void setLookupPath(Classpath newValue) {
        this.lookupPath = newValue;
    }

    public NLSIniFileDetector() {
        this.reset();
    }

    public boolean detect(String baseName) {
        this.reset();
        String filename = String.valueOf(baseName) + DEFAULT_FILE_EXTENSTION;
        this.readFileMappingsFor(filename, this.getLookupPath());
        return !this.getFileMappings().isEmpty();
    }

    public FileLocator[] getFilesForLocales(Locale[] locales) {
        String filename;
        HashSet<String> filenames = new HashSet<String>();
        if (!this.coll().isNullOrEmpty(locales)) {
            int i = 0;
            while (i < locales.length) {
                filename = (String)this.getFileMappings().get(locales[i].toString());
                if (!this.str().isNullOrEmpty(filename)) {
                    filenames.add(filename);
                }
                ++i;
            }
        }
        ArrayList<FileLocator> fileLocators = new ArrayList<FileLocator>(filenames.size());
        Iterator iter = filenames.iterator();
        while (iter.hasNext()) {
            filename = (String)iter.next();
            URL url = FileFinder.locateFileOnPath(filename, this.getLookupPath());
            if (url == null) continue;
            FileLocator locator = FileLocator.create(url);
            fileLocators.add(locator);
        }
        return (FileLocator[])this.coll().toArray(fileLocators);
    }

    public FileLocator getFileForLocales(Locale locale) {
        Object[] locators = this.getFilesForLocales(new Locale[]{locale});
        if (this.coll().isNullOrEmpty(locators)) {
            return null;
        }
        return locators[0];
    }

    protected void reset() {
        this.setFileMappings(new HashMap());
        this.setLookupPath(this.nls().getNLSLookupPath());
    }

    protected void readFileMappingsFor(String filename, Classpath classpath) {
        if (DEBUG) {
            this.debug("Lookup file <" + filename + "> in <" + classpath + ">");
        }
        ClasspathElement[] elements = classpath.elementsContaining(filename);
        int i = 0;
        while (i < elements.length) {
            if (DEBUG) {
                this.debug("Found file <" + filename + "> in <" + elements[i].getName() + ">");
            }
            this.readFileMapping(elements[i], filename);
            ++i;
        }
    }

    protected void readFileMapping(ClasspathElement element, String filename) {
        Settings settings;
        IniReaderWriter iniReader = new IniReaderWriter(filename);
        try {
            settings = iniReader.loadSettingsFrom(element);
            if (settings == null) {
                return;
            }
        }
        catch (IOException e) {
            if (DEBUG) {
                this.debug("Failed to load file <" + filename + "> from <" + element.getName() + ">");
            }
            return;
        }
        this.addFileMappings(settings);
    }

    protected void addFileMappings(Settings settings) {
        String[] keys = settings.getKeyNamesOf(FILE_MAPPING_SECTION);
        int i = 0;
        while (i < keys.length) {
            String filename = settings.getValueOf(FILE_MAPPING_SECTION, keys[i]);
            this.getFileMappings().put(keys[i], filename);
            ++i;
        }
    }

    protected CollectionUtil coll() {
        return CollectionUtil.current();
    }

    protected NLSUtil nls() {
        return NLSUtil.current();
    }

    protected StringUtil str() {
        return StringUtil.current();
    }

    private void debug(String text) {
        System.out.println(text);
    }
}

