/*
 * Decompiled with CFR 0.152.
 */
package org.pf.nls;

import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import org.pf.file.FileLocator;
import org.pf.nls.NLSUtil;
import org.pf.nls.TextContainer;
import org.pf.nls.TextContainerList;
import org.pf.settings.Settings;
import org.pf.settings.rw.IniReaderWriter;
import org.pf.text.StringFilter;
import org.pf.text.StringUtil;
import org.pf.util.CollectionUtil;

public class NLSIniFileLoader {
    public TextContainer loadText(File file, String localeName) {
        return this.loadText(file, this.nls().createLocale(localeName));
    }

    public TextContainer loadText(File file, Locale locale) {
        return this.loadText(FileLocator.create(file), locale);
    }

    public TextContainerList loadText(File file, Locale[] locales) {
        return this.loadText(FileLocator.create(file), locales);
    }

    public TextContainerList loadText(File file, String[] localeNames) {
        return this.loadText(FileLocator.create(file), localeNames);
    }

    public TextContainer loadText(FileLocator fileLocator, String localeName) {
        return this.loadText(fileLocator, this.nls().createLocale(localeName));
    }

    public TextContainer loadText(FileLocator fileLocator, Locale locale) {
        TextContainerList containerList = this.loadTextContainers(fileLocator, new Locale[]{locale});
        return containerList.getTextContainer(locale);
    }

    public TextContainerList loadText(FileLocator fileLocator, Locale[] locales) {
        return this.loadTextContainers(fileLocator, locales);
    }

    public TextContainerList loadText(FileLocator fileLocator, String[] localeNames) {
        if (fileLocator == null || this.str().isNullOrEmpty(localeNames)) {
            return null;
        }
        Object[] locales = this.stringsToLocales(localeNames);
        if (this.coll().isNullOrEmpty(locales)) {
            return null;
        }
        return this.loadTextContainers(fileLocator, (Locale[])locales);
    }

    public String getDefaultEncoding() {
        return "UTF-8";
    }

    protected TextContainerList loadTextContainers(FileLocator locator, Locale[] locales) {
        IniReaderWriter reader = new IniReaderWriter(locator, this.getCharacterEncoding());
        Settings settings = reader.loadSettings();
        if (settings == null) {
            return null;
        }
        TextContainerList textContainers = this.createTextContainerList(locales);
        String[] localeNames = this.localesToStrings(locales);
        String[] keyNames = settings.getCategoryNames();
        StringFilter metadataKeyFilter = new StringFilter(){
            final String prefix;
            {
                this.prefix = NLSIniFileLoader.this.getMetadataIndicator();
            }

            public boolean matches(String aString) {
                return aString.startsWith(this.prefix);
            }
        };
        String[] metadataKeys = this.str().copy(keyNames, metadataKeyFilter);
        String[] textKeys = this.str().copyWithout(keyNames, metadataKeyFilter);
        this.handleMetadataSections(settings, metadataKeys);
        this.handleTextKeys(textContainers, settings, textKeys, localeNames);
        return textContainers;
    }

    protected void handleTextKeys(TextContainerList textContainers, Settings settings, String[] textKeys, String[] localeNames) {
        int i = 0;
        while (i < localeNames.length) {
            TextContainer container = textContainers.getTextContainer(localeNames[i]);
            int j = 0;
            while (j < textKeys.length) {
                String textId = textKeys[j];
                String text = settings.getValueOf(textId, localeNames[i]);
                if (text != null) {
                    container.addText(textId, text);
                }
                ++j;
            }
            ++i;
        }
    }

    protected String[] localesToStrings(Locale[] locales) {
        String[] strings = new String[locales.length];
        int i = 0;
        while (i < strings.length) {
            strings[i] = locales[i].toString();
            ++i;
        }
        return strings;
    }

    protected Locale[] stringsToLocales(String[] localeNames) {
        ArrayList<Locale> locales = new ArrayList<Locale>(localeNames.length);
        int i = 0;
        while (i < localeNames.length) {
            Locale locale = this.nls().createLocale(localeNames[i]);
            if (locale != null) {
                locales.add(locale);
            }
            ++i;
        }
        return (Locale[])this.coll().toArray(locales);
    }

    protected TextContainerList createTextContainerList(Locale[] locales) {
        TextContainerList containerList = new TextContainerList();
        int i = 0;
        while (i < locales.length) {
            containerList.add(locales[i].toString(), new TextContainer(locales[i]));
            ++i;
        }
        return containerList;
    }

    protected void handleMetadataSections(Settings settings, String[] sectionNames) {
        int i = 0;
        while (i < sectionNames.length) {
            this.handleMetadataSection(settings, sectionNames[i]);
            ++i;
        }
    }

    protected void handleMetadataSection(Settings settings, String sectionName) {
    }

    protected String getCharacterEncoding() {
        if (this.getEncoding() == null) {
            return this.getDefaultEncoding();
        }
        return this.getEncoding();
    }

    protected String getEncoding() {
        return null;
    }

    protected String getMetadataIndicator() {
        return "@";
    }

    protected CollectionUtil coll() {
        return CollectionUtil.current();
    }

    protected NLSUtil nls() {
        return NLSUtil.current();
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

