/*
 * Decompiled with CFR 0.152.
 */
package org.pf.nls;

import java.util.Locale;
import org.pf.file.Classpath;
import org.pf.file.FileUtil;
import org.pf.text.StringUtil;

public class NLSUtil {
    protected static final String SYS_PROP_NLS_PATH = "org.pf.nls.path";
    private static NLSUtil soleInstance = new NLSUtil();

    public static NLSUtil current() {
        return soleInstance;
    }

    private NLSUtil() {
    }

    public Locale createLocale(String localeName) {
        if (this.str().isNullOrBlank(localeName)) {
            return null;
        }
        String[] parts = this.str().parts(localeName, "_");
        switch (parts.length) {
            case 1: {
                return new Locale(parts[0].toLowerCase());
            }
            case 2: {
                return new Locale(parts[0].toLowerCase(), parts[1].toUpperCase());
            }
            case 3: {
                return new Locale(parts[0].toLowerCase(), parts[1].toUpperCase(), parts[2]);
            }
        }
        return null;
    }

    public Classpath getNLSLookupPath() {
        return this.fileUtil().getLookupPath(SYS_PROP_NLS_PATH);
    }

    protected StringUtil str() {
        return StringUtil.current();
    }

    protected FileUtil fileUtil() {
        return FileUtil.current();
    }
}

