/*
 * Decompiled with CFR 0.152.
 */
package org.pf.nls;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.pf.nls.IExtendedTextProvider;
import org.pf.text.StringUtil;

public class TextContainer
implements IExtendedTextProvider {
    private IExtendedTextProvider defaultContainer = null;
    private Locale locale = null;
    private Map textMap = null;

    public TextContainer(Locale aLocale) {
        this.setLocale(aLocale);
        this.setTextMap(this.createNewTextMap(this.getInitialCapacity()));
    }

    public IExtendedTextProvider getDefaultProvider() {
        return this.defaultContainer;
    }

    public void setDefaultProvider(IExtendedTextProvider textContainer) {
        this.defaultContainer = textContainer;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getText(String key) {
        if (key == null) {
            return null;
        }
        String text = this.getString(key);
        if (text == null && this.hasDefaultContainer()) {
            text = this.getDefaultProvider().getText(key);
        }
        return text;
    }

    public Locale[] getLocales() {
        return new Locale[]{this.getLocale()};
    }

    public String[] getKeys() {
        return this.str().asStrings(this.getTextMap().keySet());
    }

    public boolean containsKey(String key) {
        return this.getText(key) != null;
    }

    public boolean hasKey(String key) {
        return this.getText(key) != null;
    }

    public boolean isEmpty() {
        return this.getTextMap().isEmpty();
    }

    public boolean containsNothing() {
        if (this.isEmpty()) {
            if (this.hasDefaultContainer()) {
                return this.getDefaultProvider().containsNothing();
            }
            return true;
        }
        return false;
    }

    public int size() {
        return this.getTextMap().size();
    }

    protected String getString(String key) {
        return (String)this.getTextMap().get(key);
    }

    protected void addText(String key, String text) {
        if (key != null && text != null) {
            this.getTextMap().put(key, text);
        }
    }

    protected boolean hasDefaultContainer() {
        return this.getDefaultProvider() != null;
    }

    protected int getInitialCapacity() {
        return 50;
    }

    protected Map createNewTextMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    protected void setLocale(Locale newLocale) {
        this.locale = newLocale;
    }

    protected Map getTextMap() {
        return this.textMap;
    }

    protected void setTextMap(Map newValue) {
        this.textMap = newValue;
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

