/*
 * Decompiled with CFR 0.152.
 */
package org.pf.nls;

import java.util.ArrayList;
import java.util.Locale;
import org.pf.nls.IExtendedTextProvider;
import org.pf.nls.ITextProvider;
import org.pf.nls.TextContainer;
import org.pf.util.CollectionUtil;
import org.pf.util.NamedValueList;

public class TextContainerList
extends NamedValueList
implements IExtendedTextProvider {
    private Locale[] lookupOrder = null;

    public TextContainer getTextContainer(String localeName) {
        return (TextContainer)this.valueAt(localeName);
    }

    public TextContainer getTextContainer(Locale locale) {
        return this.getTextContainer(locale.toString());
    }

    public void add(String name, TextContainer container) {
        if (name == null || container == null) {
            return;
        }
        this.remove(name);
        this.add(name, (Object)container);
    }

    public Locale[] getLocales() {
        Locale[] locales = new Locale[this.size()];
        int i = 0;
        while (i < this.size()) {
            TextContainer container = this.textContainerAt(i);
            locales[i] = container.getLocale();
            ++i;
        }
        return locales;
    }

    public String getText(String key) {
        ITextProvider[] providers = this.getOrderedTextProviders();
        int i = 0;
        while (i < providers.length) {
            String text = providers[i].getText(key);
            if (text != null) {
                return text;
            }
            ++i;
        }
        return null;
    }

    public boolean containsNothing() {
        int i = 0;
        while (i < this.size()) {
            TextContainer provider = this.textContainerAt(i);
            if (!provider.containsNothing()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Locale[] getLookupOrder() {
        return this.lookupOrder;
    }

    public void setLookupOrder(Locale[] newValue) {
        this.lookupOrder = newValue;
    }

    public TextContainer textContainerAt(int index) {
        return (TextContainer)this.valueAt(index);
    }

    protected ITextProvider[] getOrderedTextProviders() {
        ArrayList<TextContainer> providers = new ArrayList<TextContainer>();
        Locale[] locales = this.getLookupOrder();
        if (locales == null) {
            int i = 0;
            while (i < this.size()) {
                providers.add(this.textContainerAt(i));
                ++i;
            }
        } else {
            int i = 0;
            while (i < locales.length) {
                TextContainer provider = this.getTextContainer(locales[i]);
                if (provider != null) {
                    providers.add(provider);
                }
                ++i;
            }
        }
        return (ITextProvider[])CollectionUtil.current().toArray(providers);
    }
}

