/*
 * Decompiled with CFR 0.152.
 */
package org.pf.osf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pf.reflect.AttributeReadAccess;
import org.pf.reflect.AttributeReadWriteAccess;
import org.pf.util.NamedValue;
import org.pf.util.OrderedSet;

public class MapFacade
implements Map {
    private AttributeReadAccess wrappedObject = null;
    private String[] attrNames = null;

    protected AttributeReadAccess getWrappedObject() {
        return this.wrappedObject;
    }

    protected void setWrappedObject(AttributeReadAccess newValue) {
        this.wrappedObject = newValue;
    }

    protected String[] getAttrNames() {
        return this.attrNames;
    }

    protected void setAttrNames(String[] newValue) {
        this.attrNames = newValue;
    }

    public MapFacade(AttributeReadAccess object) {
        this.setObject(object);
    }

    public void setObject(AttributeReadAccess object) {
        if (object == null) {
            throw new IllegalArgumentException("Object must not be null!");
        }
        this.setWrappedObject(object);
        this.setAttrNames(null);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object key) {
        if (key != null) {
            String[] names = this.getAttributeNames();
            int i = 0;
            while (i < names.length) {
                if (names[i].equals(key)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean containsValue(Object value) {
        Collection coll = this.values();
        return coll.contains(value);
    }

    public Set entrySet() {
        String[] names = this.getAttributeNames();
        Set entrySet = this.newSet(names.length);
        int i = 0;
        while (i < names.length) {
            NamedValue entry = new NamedValue(names[i], this.get(names[i]));
            entrySet.add(entry);
            ++i;
        }
        return entrySet;
    }

    public Object get(Object key) {
        if (key instanceof String) {
            try {
                return this.getWrappedObject().getAttributeValue((String)key);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isEmpty() {
        return this.getAttributeNames().length < 1;
    }

    public Set keySet() {
        String[] names = this.getAttributeNames();
        Set keys = this.newSet(names.length);
        int i = 0;
        while (i < names.length) {
            keys.add(names[i]);
            ++i;
        }
        return keys;
    }

    public Object put(Object key, Object value) {
        if (key instanceof String && value != null && this.allowsWriteAccess()) {
            try {
                Object oldValue = this.get(key);
                this.getWriteObject().setAttributeValue((String)key, value);
                return oldValue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return null;
    }

    public void putAll(Map map) {
        if (map != null) {
            Iterator iter = this.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.getAttributeNames().length;
    }

    public Collection values() {
        String[] names = this.getAttributeNames();
        Collection coll = this.newCollection(names.length);
        int i = 0;
        while (i < names.length) {
            coll.add(this.get(names[i]));
            ++i;
        }
        return coll;
    }

    protected String[] getAttributeNames() {
        if (this.getAttrNames() == null) {
            String[] names = this.getWrappedObject().getAttributeNames();
            if (this.cacheAttributeNames()) {
                this.setAttrNames(names);
            } else {
                return names;
            }
        }
        return this.getAttrNames();
    }

    protected boolean allowsWriteAccess() {
        return this.getWrappedObject() instanceof AttributeReadWriteAccess;
    }

    protected AttributeReadWriteAccess getWriteObject() {
        return (AttributeReadWriteAccess)this.getWrappedObject();
    }

    protected boolean cacheAttributeNames() {
        return true;
    }

    protected Collection newCollection(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    protected Set newSet(int initialCapacity) {
        return new OrderedSet(initialCapacity);
    }
}

