/*
 * Decompiled with CFR 0.152.
 */
package org.pf.osf;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pf.bif.filter.IObjectFilter;
import org.pf.osf.MatchRuleFilter;
import org.pf.osf.ObjectSearchResult;
import org.pf.reflect.AttributeReadAccess;
import org.pf.text.DefaultMatchRuleParser;
import org.pf.text.MatchRule;
import org.pf.text.MatchRuleParseException;
import org.pf.text.StringUtil;

public class ObjectContainer {
    protected static final DefaultMatchRuleParser ruleParser = ObjectContainer.createParser();
    private List objects = null;

    protected List getObjects() {
        return this.objects;
    }

    protected void setObjects(List newValue) {
        this.objects = newValue;
    }

    static DefaultMatchRuleParser createParser() {
        DefaultMatchRuleParser p = new DefaultMatchRuleParser();
        p.setMultiCharWildcardMatchesEmptyString(true);
        return p;
    }

    public ObjectContainer() {
        this(20);
    }

    public ObjectContainer(int initialCapacity) {
        this.setObjects(this.newList(initialCapacity));
    }

    public void add(AttributeReadAccess object) {
        if (object != null) {
            this.getObjects().add(object);
        }
    }

    public AttributeReadAccess get(int index) {
        return (AttributeReadAccess)this.getObjects().get(index);
    }

    public AttributeReadAccess set(int index, AttributeReadAccess object) {
        if (object != null) {
            return this.getObjects().set(index, object);
        }
        return null;
    }

    public void clear() {
        this.getObjects().clear();
    }

    public ObjectContainer copy() {
        ObjectContainer copy = new ObjectContainer(0);
        copy.setObjects(this.asList());
        return copy;
    }

    public boolean remove(AttributeReadAccess object) {
        if (object != null) {
            Iterator iter = this.getObjects().iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (object != element) continue;
                iter.remove();
                return true;
            }
        }
        return false;
    }

    public boolean removeEqual(AttributeReadAccess object) {
        if (object != null) {
            Iterator iter = this.getObjects().iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!object.equals(element)) continue;
                iter.remove();
                return true;
            }
        }
        return false;
    }

    public int size() {
        return this.getObjects().size();
    }

    public boolean isEmpty() {
        return this.getObjects().isEmpty();
    }

    public boolean containsEqualObject(AttributeReadAccess object) {
        if (object != null) {
            return this.getObjects().contains(object);
        }
        return false;
    }

    public boolean contains(AttributeReadAccess object) {
        if (object != null) {
            Iterator iter = this.getObjects().iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (object != element) continue;
                return true;
            }
        }
        return false;
    }

    public AttributeReadAccess findFirst(String rule) throws MatchRuleParseException {
        ObjectSearchResult result = this.find(rule, true, false);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public AttributeReadAccess findFirstIgnoreCase(String rule) throws MatchRuleParseException {
        ObjectSearchResult result = this.find(rule, true, true);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public ObjectSearchResult find(String rule) throws MatchRuleParseException {
        return this.find(rule, false, false);
    }

    public ObjectSearchResult findIgnoreCase(String rule) throws MatchRuleParseException {
        return this.find(rule, false, true);
    }

    public ObjectSearchResult find(MatchRule rule) {
        return this.find(rule, false);
    }

    public ObjectSearchResult find(IObjectFilter filter) {
        return this.find(filter, false);
    }

    public void find(ObjectSearchResult result, MatchRule rule) {
        this.collect(result, rule, false);
    }

    public void find(ObjectSearchResult result, IObjectFilter filter) {
        this.collect(result, filter, false);
    }

    public void find(ObjectSearchResult result, String rule, boolean ignoreCase) throws MatchRuleParseException {
        MatchRule matchRule = this.parseMatchRule(rule, ignoreCase);
        this.find(result, matchRule);
    }

    public AttributeReadAccess findFirst(MatchRule rule) {
        ObjectSearchResult result = this.find(rule, true);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public AttributeReadAccess findFirst(IObjectFilter filter) {
        ObjectSearchResult result = this.find(filter, true);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public List asList() {
        List list = this.newList(this.size());
        list.addAll(this.getObjects());
        return list;
    }

    public Object[] asArray(Class elementType) {
        Object[] array = (Object[])Array.newInstance(elementType, this.size());
        this.getObjects().toArray(array);
        return array;
    }

    protected void collect(ObjectSearchResult result, MatchRule rule, boolean first) {
        MatchRuleFilter filter = new MatchRuleFilter(rule);
        this.collect(result, filter, first);
    }

    protected void collect(ObjectSearchResult result, IObjectFilter filter, boolean first) {
        Iterator iter = this.getObjects().iterator();
        while (!result.isSizeLimitExceeded() && iter.hasNext()) {
            AttributeReadAccess element = (AttributeReadAccess)iter.next();
            if (!filter.matches(element)) continue;
            result.add(element);
            if (!first) continue;
            return;
        }
    }

    protected ObjectSearchResult find(MatchRule rule, boolean first) {
        ObjectSearchResult result = this.newResult(first ? 1 : 50);
        this.collect(result, rule, first);
        return result;
    }

    protected ObjectSearchResult find(IObjectFilter filter, boolean first) {
        ObjectSearchResult result = this.newResult(first ? 1 : 50);
        this.collect(result, filter, first);
        return result;
    }

    protected ObjectSearchResult find(String rule, boolean first, boolean ignoreCase) throws MatchRuleParseException {
        MatchRule matchRule = this.parseMatchRule(rule, ignoreCase);
        return this.find(matchRule, first);
    }

    protected MatchRule parseMatchRule(String rule, boolean ignoreCase) throws MatchRuleParseException {
        MatchRule matchRule = this.getRuleParser().parse(rule);
        matchRule.ignoreCase(ignoreCase);
        matchRule.ignoreCaseInNames(ignoreCase);
        return matchRule;
    }

    protected ObjectSearchResult newResult(int initialCapacity) {
        if (initialCapacity <= 1) {
            return new ObjectSearchResult(1);
        }
        return new ObjectSearchResult(40);
    }

    protected List newList(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    protected DefaultMatchRuleParser getRuleParser() {
        return ruleParser;
    }

    protected class DummyObject
    implements AttributeReadAccess {
        protected DummyObject() {
        }

        public String[] getAttributeNames() {
            return StringUtil.EMPTY_STRING_ARRAY;
        }

        public Object getAttributeValue(String name) throws NoSuchFieldException {
            return null;
        }
    }
}

