/*
 * Decompiled with CFR 0.152.
 */
package org.pf.osf;

import org.pf.osf.ObjectContainer;
import org.pf.reflect.AttributeReadAccess;

public class ObjectSearchResult
extends ObjectContainer {
    public static final int UNLIMITED_SIZE = 0;
    private int sizeLimit = 0;
    private boolean sizeLimitExceeded = false;

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int limit) {
        this.sizeLimit = limit;
    }

    protected boolean getSizeLimitExceeded() {
        return this.sizeLimitExceeded;
    }

    protected void setSizeLimitExceeded(boolean newValue) {
        this.sizeLimitExceeded = newValue;
    }

    public ObjectSearchResult() {
    }

    public ObjectSearchResult(int initialCapacity) {
        super(initialCapacity);
    }

    public ObjectSearchResult(int initialCapacity, int maximumSize) {
        super(initialCapacity > maximumSize ? maximumSize : initialCapacity);
        this.setSizeLimit(maximumSize);
    }

    public void add(AttributeReadAccess object) {
        if (this.isFull()) {
            this.setSizeLimitExceeded(true);
            return;
        }
        super.add(object);
    }

    public void clear() {
        super.clear();
        this.setSizeLimitExceeded(false);
    }

    public boolean remove(AttributeReadAccess object) {
        boolean removed = super.remove(object);
        if (this.isSizeLimitExceeded() && removed) {
            this.setSizeLimitExceeded(false);
        }
        return removed;
    }

    public boolean isFull() {
        if (this.getSizeLimit() <= 0) {
            return false;
        }
        return this.size() >= this.getSizeLimit();
    }

    public boolean isSizeLimitExceeded() {
        return this.getSizeLimitExceeded();
    }
}

