/*
 * Decompiled with CFR 0.152.
 */
package org.pf.pax;

import java.util.Stack;
import org.pf.pax.XMLTagInterpreter;
import org.pf.pax.XMLTagInterpreterController;
import org.pf.pax.XMLTagInterpreterFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseXMLTagInterpreterController
extends DefaultHandler
implements XMLTagInterpreterController {
    private XMLReader reader = null;
    private Stack interpreterStack = null;
    private XMLTagInterpreterFactory interpreterFactory = null;

    protected XMLReader getReader() {
        return this.reader;
    }

    protected void setReader(XMLReader aValue) {
        this.reader = aValue;
    }

    protected Stack getInterpreterStack() {
        return this.interpreterStack;
    }

    protected void setInterpreterStack(Stack aValue) {
        this.interpreterStack = aValue;
    }

    protected XMLTagInterpreterFactory getInterpreterFactory() {
        return this.interpreterFactory;
    }

    protected void setInterpreterFactory(XMLTagInterpreterFactory aValue) {
        this.interpreterFactory = aValue;
    }

    public BaseXMLTagInterpreterController() {
        this.setInterpreterStack(new Stack());
        this.setInterpreterFactory(this.createTagInterpreterFactory());
    }

    public BaseXMLTagInterpreterController(XMLReader xmlReader) {
        this();
        this.setXmlReader(xmlReader);
    }

    public void returnControl(Object result) throws SAXException {
        XMLTagInterpreter previous = null;
        XMLTagInterpreter current = null;
        current = this.popFromStack();
        this.trace("Returned from " + current.getTagName() + " - interpreter.");
        if (this.isStackEmpty()) {
            this.getReader().setContentHandler(this);
            this.handleFinalResult(result);
        } else {
            previous = this.peekStack();
            this.trace("Restarting interpreter for " + previous.getTagName());
            this.restartInterpreter(previous, current.getTagName(), result);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.startElement(qName, attributes);
    }

    public void startElement(String name, Attributes attributes) throws SAXException {
        XMLTagInterpreter interpreter = null;
        interpreter = this.getInterpreterFor(name);
        if (interpreter == null) {
            throw new SAXException("Interpreter for <" + name + "> not found !");
        }
        this.putOnStack(interpreter);
        interpreter.setController(this);
        this.startInterpreter(interpreter, name, attributes);
    }

    public XMLReader getXmlReader() {
        return this.getReader();
    }

    public void setXmlReader(XMLReader aReader) {
        if (this.getReader() != null) {
            this.getReader().setContentHandler(null);
        }
        this.setReader(aReader);
        if (aReader != null) {
            aReader.setContentHandler(this);
        }
    }

    protected abstract void handleFinalResult(Object var1);

    protected abstract XMLTagInterpreterFactory createTagInterpreterFactory();

    protected void startInterpreter(XMLTagInterpreter interpreter, String elementName, Attributes attributes) throws SAXException {
        this.trace("Start interpreter for <" + elementName + "> first time");
        interpreter.start(elementName, attributes);
        this.getReader().setContentHandler(interpreter);
    }

    protected void restartInterpreter(XMLTagInterpreter interpreter, String subTagName, Object result) throws SAXException {
        interpreter.restart(subTagName, result);
        this.getReader().setContentHandler(interpreter);
    }

    protected XMLTagInterpreter getInterpreterFor(String tagName) throws SAXException {
        XMLTagInterpreter interpreter = null;
        interpreter = this.getInterpreterFactory().getInterpreterFor(tagName);
        return interpreter;
    }

    protected XMLTagInterpreter popFromStack() {
        return (XMLTagInterpreter)this.getInterpreterStack().pop();
    }

    protected XMLTagInterpreter peekStack() {
        return (XMLTagInterpreter)this.getInterpreterStack().peek();
    }

    protected void putOnStack(XMLTagInterpreter interpreter) {
        this.getInterpreterStack().push(interpreter);
    }

    protected boolean isStackEmpty() {
        return this.getInterpreterStack().isEmpty();
    }

    protected void trace(String text) {
    }
}

