/*
 * Decompiled with CFR 0.152.
 */
package org.pf.pax;

import java.util.Hashtable;
import java.util.Map;
import org.pf.pax.XMLTagInterpreter;
import org.pf.pax.XMLTagInterpreterFactory;
import org.xml.sax.SAXException;

public abstract class BaseXMLTagInterpreterFactory
implements XMLTagInterpreterFactory {
    private Map classNameRegistry = new Hashtable();
    private Map classRegistry = new Hashtable();

    protected Map getClassNameRegistry() {
        return this.classNameRegistry;
    }

    protected void setClassNameRegistry(Map aValue) {
        this.classNameRegistry = aValue;
    }

    protected Map getClassRegistry() {
        return this.classRegistry;
    }

    protected void setClassRegistry(Map aValue) {
        this.classRegistry = aValue;
    }

    public XMLTagInterpreter getInterpreterFor(String tagName) throws SAXException {
        Class interpreterClass = null;
        XMLTagInterpreter interpreter = null;
        interpreterClass = this.getInterpreterClassFor(tagName);
        if (interpreterClass != null) {
            try {
                interpreter = (XMLTagInterpreter)interpreterClass.newInstance();
            }
            catch (Exception ex) {
                String msg = "Could not create new instance of interpreter class '";
                msg = String.valueOf(msg) + interpreterClass.getName() + "'\n";
                msg = String.valueOf(msg) + ex.toString();
                throw new SAXException(msg);
            }
        }
        return interpreter;
    }

    protected void registerTagInterpreter(String tagName, String className) {
        this.getClassNameRegistry().put(tagName, className);
    }

    protected Class getInterpreterClassFor(String tagName) throws SAXException {
        String className = null;
        Class<?> interpreterClass = null;
        interpreterClass = (Class<?>)this.getClassRegistry().get(tagName);
        if (interpreterClass == null && (className = (String)this.getClassNameRegistry().get(tagName)) != null) {
            try {
                interpreterClass = Class.forName(className);
                this.getClassRegistry().put(tagName, interpreterClass);
            }
            catch (Exception ex) {
                throw new SAXException("Interpreter class '" + className + "' not found !");
            }
        }
        return interpreterClass;
    }
}

