/*
 * Decompiled with CFR 0.152.
 */
package org.pf.pax;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.pf.pax.SAXConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class DOMTreeXMLReader
implements XMLReader,
SAXConstants {
    protected static final String NAMESPACE_ATTR = "xmlns";
    private ContentHandler contentHandler = null;
    private Map features = null;

    protected Map getFeatures() {
        return this.features;
    }

    protected void setFeatures(Map newValue) {
        this.features = newValue;
    }

    public DOMTreeXMLReader() {
        this.initFeatures();
    }

    public void setContentHandler(ContentHandler newValue) {
        this.contentHandler = newValue;
    }

    public void parse(Document document) throws SAXException {
        if (document == null) {
            throw new SAXException("The given document is null !");
        }
        this.parseDocument(document);
    }

    public void parse(InputSource source) throws SAXException {
        this.notSupportedError("parse( InputSource source )");
    }

    public void parse(String systemId) throws SAXException {
        this.notSupportedError("parse( String systemId )");
    }

    public void setDTDHandler(DTDHandler handler) {
    }

    public void setEntityResolver(EntityResolver resolver) {
    }

    public void setErrorHandler(ErrorHandler handler) {
    }

    public void setLocale(Locale locale) throws SAXException {
        this.notSupportedError("setLocale( java.util.Locale locale )");
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(name);
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean bool = this.lookupFeature(name);
        if (bool == null) {
            throw new SAXNotRecognizedException("Unknown feature <" + name + ">");
        }
        return bool;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        boolean currentValue = this.getFeature(name);
        if (value != currentValue) {
            this.basicSetFeature(name, value);
        }
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    protected void notSupportedError(String text) throws SAXException {
        throw new SAXException("This method is not supported: " + text);
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    protected void parseDocument(Document document) throws SAXException {
        this.getContentHandler().startDocument();
        this.handleNodes(document.getChildNodes());
        this.getContentHandler().endDocument();
    }

    protected void handleNodes(NodeList nodes) throws SAXException {
        int index = 0;
        while (index < nodes.getLength()) {
            this.handleNode(nodes.item(index));
            ++index;
        }
    }

    protected void handleNode(Node node) throws SAXException {
        switch (node.getNodeType()) {
            case 1: {
                this.handleElement((Element)node);
                break;
            }
            case 3: {
                this.handleText((Text)node);
                break;
            }
            case 7: {
                this.handleProcessingInstruction((ProcessingInstruction)node);
                break;
            }
            case 4: {
                this.handleCData((CDATASection)node);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                break;
            }
            case 2: 
            case 9: 
            case 11: {
                throw new SAXException("Element at wrong place found: " + node.toString());
            }
            default: {
                throw new SAXException("Unknown element found: " + node.toString());
            }
        }
    }

    protected void handleElement(Element element) throws SAXException {
        Name name;
        AttributesImpl attrList = new AttributesImpl();
        Attr attribute = null;
        NamedNodeMap attrMap = element.getAttributes();
        Properties prefixDeclarations = new Properties();
        int index = 0;
        while (index < attrMap.getLength()) {
            attribute = (Attr)attrMap.item(index);
            name = new Name(attribute);
            attrList.addAttribute(name.namespaceURI, name.localName, name.qName, "CDATA", attribute.getValue());
            if (this.supportNamespaces() && name.isNamespaceAttribute()) {
                prefixDeclarations.setProperty(name.getWithoutPrefix(), attribute.getValue());
            }
            ++index;
        }
        name = new Name(element);
        if (this.supportNamespaces()) {
            this.triggerPrefixEvent(prefixDeclarations, true);
        }
        this.getContentHandler().startElement(name.namespaceURI, name.localName, name.qName, attrList);
        this.handleNodes(element.getChildNodes());
        this.getContentHandler().endElement(name.namespaceURI, name.localName, name.qName);
        if (this.supportNamespaces()) {
            this.triggerPrefixEvent(prefixDeclarations, false);
        }
    }

    protected void handleText(Text text) throws SAXException {
        String data = text.getData();
        this.getContentHandler().characters(data.toCharArray(), 0, data.length());
    }

    protected void handleProcessingInstruction(ProcessingInstruction instruction) throws SAXException {
        this.getContentHandler().processingInstruction(instruction.getTarget(), instruction.getData());
    }

    protected void handleCData(CDATASection cdata) throws SAXException {
    }

    protected void triggerPrefixEvent(Properties declarations, boolean start) throws SAXException {
        if (declarations == null || ((Hashtable)declarations).isEmpty()) {
            return;
        }
        Enumeration<?> prefixes = declarations.propertyNames();
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            String uri = declarations.getProperty(prefix);
            if (start) {
                this.getContentHandler().startPrefixMapping(prefix, uri);
                continue;
            }
            this.getContentHandler().endPrefixMapping(prefix);
        }
    }

    protected Boolean lookupFeature(String featureName) {
        return (Boolean)this.getFeatures().get(featureName);
    }

    protected boolean supportNamespaces() {
        return this.isFeatureOn("http://xml.org/sax/features/namespaces");
    }

    protected boolean supportNamespacePrefixes() {
        return this.isFeatureOn("http://xml.org/sax/features/namespace-prefixes");
    }

    protected boolean isFeatureOn(String featureName) {
        try {
            return this.getFeature(featureName);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void basicSetFeature(String name, boolean value) {
        this.getFeatures().put(name, value ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void initFeatures() {
        this.setFeatures(new HashMap());
        this.basicSetFeature("http://xml.org/sax/features/namespaces", true);
        this.basicSetFeature("http://xml.org/sax/features/namespace-prefixes", false);
    }

    class Name {
        static final String EMPTY = "";
        private boolean is_xmlns = false;
        String namespaceURI;
        String localName;
        String qName;

        Name(String uri, String local, String qName) {
            this.namespaceURI = uri;
            this.localName = local;
            this.qName = qName;
        }

        Name(Node node) {
            this.qName = node.getNodeType() == 1 ? ((Element)node).getTagName() : node.getNodeName();
            if (!DOMTreeXMLReader.this.supportNamespacePrefixes()) {
                this.qName = this.nameWithoutPrefix(this.qName);
            }
            if (node.getNodeType() == 2) {
                this.is_xmlns = node.getNodeName().startsWith(DOMTreeXMLReader.NAMESPACE_ATTR);
            }
            if (DOMTreeXMLReader.this.supportNamespaces()) {
                if (this.is_xmlns) {
                    this.namespaceURI = EMPTY;
                    this.localName = DOMTreeXMLReader.this.supportNamespacePrefixes() ? EMPTY : node.getLocalName();
                } else {
                    this.namespaceURI = node.getNamespaceURI();
                    if (this.namespaceURI == null) {
                        this.namespaceURI = EMPTY;
                    }
                    this.localName = node.getLocalName();
                    if (this.localName == null) {
                        this.localName = this.nameWithoutPrefix(this.qName);
                    }
                }
            } else {
                this.namespaceURI = EMPTY;
                this.localName = EMPTY;
            }
        }

        public String getWithoutPrefix() {
            if (this.localName != null && this.localName.length() > 0) {
                return this.localName;
            }
            return this.nameWithoutPrefix(this.qName);
        }

        public String getPrefix() {
            int index = this.qName.indexOf(58);
            if (index > 0) {
                return this.qName.substring(0, index);
            }
            return EMPTY;
        }

        public boolean isNamespaceAttribute() {
            return this.is_xmlns;
        }

        private String nameWithoutPrefix(String name) {
            if (name == null) {
                return null;
            }
            int index = name.indexOf(58);
            if (index > 0) {
                return name.substring(index + 1);
            }
            return name;
        }
    }
}

