/*
 * Decompiled with CFR 0.152.
 */
package org.pf.pax;

import java.io.IOException;
import java.io.Writer;
import org.pf.logging.Logger;
import org.pf.pax.LoggerProvider;

public class MarkupWriter {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final char SINGLE_QUOTE_CHAR = '\'';
    private static final char DOUBLE_QUOTE_CHAR = '\"';
    private static char[] SpecialCharacters = MarkupWriter.initSpecialCharacters();
    private static String[] Placeholders = MarkupWriter.initPlaceholders();
    private Writer writer = null;
    private int indentLevel = 0;
    private int indentIncrement = 2;
    private char quoteChar = (char)34;

    protected Writer getWriter() {
        return this.writer;
    }

    protected void setWriter(Writer newValue) {
        this.writer = newValue;
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    protected void setIndentLevel(int newValue) {
        this.indentLevel = newValue;
    }

    public int getIndentIncrement() {
        return this.indentIncrement;
    }

    public void setIndentIncrement(int newValue) {
        this.indentIncrement = newValue;
    }

    protected char getQuoteChar() {
        return this.quoteChar;
    }

    protected void setQuoteChar(char newValue) {
        this.quoteChar = newValue;
    }

    private static char[] initSpecialCharacters() {
        char[] characters = new char[]{'<', '>', '&'};
        return characters;
    }

    private static String[] initPlaceholders() {
        String[] ph = new String[]{"&lt;", "&gt;", "&amp;"};
        return ph;
    }

    public MarkupWriter(Writer writer) {
        this.setWriter(writer);
    }

    public void writeStartTag(String tagName) {
        this.beginStartTag(tagName);
        this.closeTag();
    }

    public void beginStartTag(String tagName) {
        this.beginTag();
        this.write(tagName);
    }

    public void writeEndTag(String tagName) {
        this.beginTag();
        this.write("/");
        this.write(tagName);
        this.closeTag();
    }

    public void writeEmptyTag(String tagName) {
        this.beginTag();
        this.write(tagName);
        this.finishEmptyTag();
    }

    public void finishEmptyTag() {
        this.writeSpace();
        this.write("/");
        this.closeTag();
    }

    public void finishTag() {
        this.closeTag();
    }

    public void writeAttribute(String attrName, String value) {
        this.writeSpace();
        this.write(attrName);
        this.writeAssignment();
        this.writeQuote();
        this.writeCharData(value, true);
        this.writeQuote();
    }

    public void writeText(String text) {
        this.writeCharData(text, false);
    }

    public void newIndentedLine() {
        this.write(NEWLINE);
        this.writeIndentation();
    }

    public void newIncIndentedLine() {
        this.incIndent();
        this.newIndentedLine();
    }

    public void newDecIndentedLine() {
        this.decIndent();
        this.newIndentedLine();
    }

    public String contents() {
        return this.getWriter().toString();
    }

    public void incIndent() {
        this.indentLevel += this.indentIncrement;
    }

    public void decIndent() {
        this.indentLevel -= this.indentIncrement;
    }

    public void useSingleQuotes() {
        this.setQuoteChar('\'');
    }

    public void useDoubleQuotes() {
        this.setQuoteChar('\"');
    }

    protected void beginTag() {
        this.write("<");
    }

    protected void closeTag() {
        this.write(">");
    }

    protected void writeSpace() {
        this.write(" ");
    }

    protected void writeAssignment() {
        this.write("=");
    }

    protected void writeQuote() {
        this.write(this.getQuoteChar());
    }

    protected void writeCharData(String text, boolean asAttrValue) {
        int index = 0;
        while (index < text.length()) {
            this.write(this.translateCharacter(text.charAt(index), asAttrValue));
            ++index;
        }
    }

    protected void write(String text) {
        try {
            this.getWriter().write(text);
        }
        catch (IOException ex) {
            this.logger().logException(ex);
        }
    }

    protected void write(char ch) {
        try {
            this.getWriter().write(ch);
        }
        catch (IOException ex) {
            this.logger().logException(ex);
        }
    }

    protected void flush() {
        try {
            this.getWriter().flush();
        }
        catch (IOException ex) {
            this.logger().logException(ex);
        }
    }

    protected void writeIndentation() {
        int i = 1;
        while (i <= this.indentLevel) {
            this.writeSpace();
            ++i;
        }
    }

    protected int findSpecialChar(char ch) {
        int i = 0;
        while (i < SpecialCharacters.length) {
            if (SpecialCharacters[i] == ch) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected String translateCharacter(char ch, boolean transQuote) {
        int index;
        if (ch == this.getQuoteChar() && transQuote) {
            switch (ch) {
                case '\'': {
                    return "&apos;";
                }
                case '\"': {
                    return "&quot;";
                }
            }
        }
        if ((index = this.findSpecialChar(ch)) >= 0) {
            return Placeholders[index];
        }
        return String.valueOf(ch);
    }

    protected Logger logger() {
        return LoggerProvider.getLogger();
    }
}

