/*
 * Decompiled with CFR 0.152.
 */
package org.pf.pax;

import org.pf.pax.BaseXMLTagInterpreter;
import org.pf.pax.MarkupWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLWriteInterpreter
extends BaseXMLTagInterpreter {
    private String tagName = null;
    private MarkupWriter markupWriter = null;
    protected boolean isEmptyTag = true;
    protected boolean lastWasInnerTag = false;

    public String getTagName() {
        return this.tagName;
    }

    protected void setTagName(String newValue) {
        this.tagName = newValue;
    }

    protected MarkupWriter getMarkupWriter() {
        return this.markupWriter;
    }

    protected void setMarkupWriter(MarkupWriter newValue) {
        this.markupWriter = newValue;
    }

    public XMLWriteInterpreter(String name, MarkupWriter writer) {
        this.setTagName(name);
        this.setMarkupWriter(writer);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.checkEmptyTag();
        this.markupWriter.newIncIndentedLine();
        super.startElement(uri, localName, qName, attributes);
    }

    public void start(String elementName, Attributes attributes) throws SAXException {
        this.markupWriter.beginStartTag(elementName);
        int index = 0;
        while (index < attributes.getLength()) {
            this.markupWriter.writeAttribute(attributes.getQName(index), attributes.getValue(index));
            ++index;
        }
    }

    public void restart(String subTagName, Object subResult) throws SAXException {
        this.markupWriter.decIndent();
        this.lastWasInnerTag = true;
    }

    public Object getResult() {
        return null;
    }

    public void characterData(String data) {
        this.checkEmptyTag();
        this.markupWriter.writeText(data);
        this.lastWasInnerTag = false;
    }

    protected void checkEmptyTag() {
        if (this.isEmptyTag) {
            this.isEmptyTag = false;
            this.markupWriter.finishTag();
        }
    }

    protected void finalizeResult() {
        if (this.isEmptyTag) {
            this.markupWriter.finishEmptyTag();
        } else {
            if (this.lastWasInnerTag) {
                this.markupWriter.newIndentedLine();
            }
            this.markupWriter.writeEndTag(this.getTagName());
        }
    }
}

