/*
 * Decompiled with CFR 0.152.
 */
package org.pf.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import org.pf.reflect.ReflectUtil;

public abstract class Dynamic {
    public static Object invoke(Object receiver, String methodName) {
        Object result = null;
        try {
            result = Dynamic.perform(receiver, methodName);
        }
        catch (Exception ex) {
            result = ex;
        }
        return result;
    }

    public static Object invoke(Object receiver, String methodName, Object arg) {
        Object result = null;
        try {
            result = Dynamic.perform(receiver, methodName, arg);
        }
        catch (Exception ex) {
            result = ex;
        }
        return result;
    }

    public static Object invoke(Object receiver, String methodName, int arg) {
        Object result = null;
        try {
            result = Dynamic.perform(receiver, methodName, arg);
        }
        catch (Exception ex) {
            result = ex;
        }
        return result;
    }

    public static Object invoke(Object receiver, String methodName, boolean arg) {
        Object result = null;
        try {
            result = Dynamic.perform(receiver, methodName, arg);
        }
        catch (Exception ex) {
            result = ex;
        }
        return result;
    }

    public static Object invoke(Object receiver, String methodName, Object[] args) {
        Object result = null;
        try {
            result = Dynamic.perform(receiver, methodName, args);
        }
        catch (Exception ex) {
            result = ex;
        }
        return result;
    }

    public static Object invoke(Object receiver, String methodName, Object[] args, Class[] argTypes) {
        Object result = null;
        try {
            result = Dynamic.perform(receiver, methodName, args, argTypes);
        }
        catch (Exception ex) {
            result = ex;
        }
        return result;
    }

    public static Object perform(Object receiver, String methodName) throws Exception {
        return Dynamic.perform(receiver, methodName, new Object[0], new Class[0]);
    }

    public static Object perform(Object receiver, String methodName, Object arg) throws Exception {
        Object[] args = new Object[]{arg};
        Class[] types = new Class[]{Dynamic.getTypeOf(arg)};
        return Dynamic.perform(receiver, methodName, args, types);
    }

    public static Object perform(Object receiver, String methodName, int arg) throws Exception {
        Object[] args = new Object[]{new Integer(arg)};
        Class[] types = new Class[]{Integer.TYPE};
        return Dynamic.perform(receiver, methodName, args, types);
    }

    public static Object perform(Object receiver, String methodName, boolean arg) throws Exception {
        Object[] args = new Object[]{arg ? Boolean.TRUE : Boolean.FALSE};
        Class[] types = new Class[]{Boolean.TYPE};
        return Dynamic.perform(receiver, methodName, args, types);
    }

    public static Object perform(Object receiver, String methodName, Object[] args) throws Exception {
        Class[] types = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            types[i] = Dynamic.getTypeOf(args[i]);
            ++i;
        }
        return Dynamic.perform(receiver, methodName, args, types);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object perform(Object receiver, String methodName, Object[] args, Class[] argTypes) throws Exception {
        Object result = null;
        Class<?> aClass = null;
        Method method = null;
        boolean saveAccessibility = false;
        if (receiver == null) {
            throw new NullPointerException();
        }
        aClass = receiver instanceof Class ? (Class<?>)receiver : receiver.getClass();
        method = Dynamic.findMethod(aClass, methodName, argTypes);
        if (method == null) {
            StringBuffer msg = new StringBuffer(80);
            msg.append("No such method: ");
            msg.append(aClass.getName());
            msg.append(".");
            msg.append(methodName);
            msg.append("(");
            if (argTypes == null) throw new Exception(msg.toString());
            int i = 0;
            while (true) {
                if (i >= argTypes.length) {
                    msg.append(")");
                    throw new Exception(msg.toString());
                }
                if (i > 0) {
                    msg.append(",");
                }
                msg.append(argTypes[i].getName());
                ++i;
            }
        }
        saveAccessibility = method.isAccessible();
        ((AccessibleObject)method).setAccessible(true);
        try {
            result = method.invoke(receiver, args);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ((AccessibleObject)method).setAccessible(saveAccessibility);
            throw throwable;
        }
        {
            Object var8_10 = null;
            ((AccessibleObject)method).setAccessible(saveAccessibility);
            return result;
        }
    }

    protected static Class getTypeOf(Object object) {
        if (object == null) {
            throw new NullPointerException("Type of null value cannot be determined");
        }
        return ReflectUtil.current().getTypeOf(object);
    }

    protected static Method findMethod(Class aClass, String methodName, Class[] paramTypes) {
        return ReflectUtil.current().findMethod(aClass, methodName, paramTypes);
    }
}

